/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.util.xml.XMLNodeTraverser;
import java.awt.Font;
import javax.swing.JComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

class FontNodeTraverser
extends XMLNodeTraverser {
    private int size;
    private String face;
    private int style;

    FontNodeTraverser() {
    }

    void traverse(Node node, JComponent c) throws XMLNodeTraverser.BadXMLException {
        super.traverse(node);
        c.setFont(new Font(this.face, this.style, this.size));
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("face")) {
            this.face = value;
        } else if (name.equals("style")) {
            this.style = this.toFontStyle(value);
        } else if (name.equals("points")) {
            this.size = this.toInt(value);
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    private int toFontStyle(String s) {
        if (s.equalsIgnoreCase("PLAIN")) {
            return 0;
        }
        if (s.equalsIgnoreCase("BOLD")) {
            return 1;
        }
        if (s.equalsIgnoreCase("ITALIC")) {
            return 2;
        }
        if (s.equalsIgnoreCase("BOLD+ITALIC")) {
            return 3;
        }
        return 0;
    }
}

