/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.application.Application;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.commanddispatcher.CommandTargetManager;

public class InternalFramePageManager
extends PageManager {
    private int m_nCascaded = 0;
    private boolean init = false;
    private final int m_xCascadeOffset = 20;
    private final int m_yCascadeOffset = 20;
    private final float m_xCascadeFraction = 0.75f;
    private final float m_yCascadeFraction = 0.75f;
    public static final int CASCADE = -3;
    public static final int TILE_HORIZONTALLY = -4;
    public static final int TILE_VERTICALLY = -5;
    private Map map;
    private JDesktopPane top;

    public InternalFramePageManager() {
        this.setPageManagerType("Window");
    }

    @Override
    protected void show(PageContext page) {
        try {
            JInternalFrame frame = this.frameForPage(page);
            frame.moveToFront();
            if (frame.isIcon()) {
                frame.setIcon(false);
            }
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    protected Component getEmbodiment() {
        return this.top;
    }

    @Override
    protected boolean close(PageContext page) {
        boolean ok = super.close(page);
        if (ok) {
            ((JInternalFrame)this.map.remove(page)).dispose();
        }
        return ok;
    }

    @Override
    protected void titleChanged(PageContext page) {
        this.frameForPage(page).setTitle(page.getTitle());
    }

    @Override
    protected void iconChanged(PageContext page) {
        this.frameForPage(page).setFrameIcon(page.getIcon());
    }

    private JInternalFrame frameForPage(PageContext page) {
        return (JInternalFrame)this.map.get(page);
    }

    @Override
    public PageContext openPage(Component c, String title, Icon icon, String type) {
        PageContext context = super.openPage(c, title, icon, type);
        FrameWithContext frame = new FrameWithContext(context);
        this.map.put(context, frame);
        this.top.add(frame);
        if (this.init) {
            this.cascadeFrame(frame);
        }
        frame.setVisible(true);
        super.firePageOpened(context);
        return context;
    }

    @Override
    protected void init(List pages, PageContext selected) {
        for (PageContext context : pages) {
            FrameWithContext frame = new FrameWithContext(context);
            this.map.put(context, frame);
            this.top.add(frame);
            frame.setVisible(true);
        }
        if (selected != null) {
            try {
                this.frameForPage(selected).setSelected(true);
            }
            catch (PropertyVetoException x) {
                // empty catch block
            }
        }
        super.init(pages, selected);
    }

    private void cascadeFrame(JInternalFrame frame) {
        Dimension paneSize = this.top.getSize();
        Dimension frameSize = new Dimension();
        frameSize.height = (int)((float)paneSize.height * 0.75f);
        frameSize.width = (int)((float)paneSize.width * 0.75f);
        Point position = new Point();
        position.translate(this.m_nCascaded * 20, this.m_nCascaded * 20);
        frame.setLocation(position);
        frame.setPreferredSize(frameSize);
        frame.setSize(frameSize);
        ++this.m_nCascaded;
    }

    void arrange(int index) {
        this.m_nCascaded = 0;
        JInternalFrame[] frames = this.top.getAllFrames();
        if (index == -3) {
            for (int i = frames.length - 1; i >= 0; --i) {
                JInternalFrame frame = frames[i];
                if (frame.isIcon()) continue;
                try {
                    frames[i].setMaximum(false);
                    this.cascadeFrame(frame);
                    continue;
                }
                catch (PropertyVetoException x) {
                    // empty catch block
                }
            }
        } else {
            int numberOfWindows;
            int nLeft = numberOfWindows = this.getPageCount();
            for (int i = 0; i < numberOfWindows; ++i) {
                if (frames[i].isIcon()) {
                    --nLeft;
                    continue;
                }
                try {
                    frames[i].setMaximum(false);
                    continue;
                }
                catch (PropertyVetoException x) {
                    --nLeft;
                }
            }
            int n = (int)Math.sqrt(nLeft);
            if (n < 1) {
                return;
            }
            int paneWidth = this.top.getSize().width;
            int paneHeight = this.top.getSize().height;
            boolean isHorizontal = index == -4;
            int xTranslation_1 = isHorizontal ? paneWidth / n : 0;
            int yTranslation_1 = isHorizontal ? 0 : paneHeight / n;
            int k = 0;
            Dimension size = new Dimension();
            Point point = new Point();
            int xTranslation_2 = 0;
            int yTranslation_2 = 0;
            if (isHorizontal) {
                size.width = paneWidth / n;
            } else {
                size.height = paneHeight / n;
            }
            block6: for (int i = 0; i < n; ++i) {
                point.setLocation(0, 0);
                point.translate(i * xTranslation_1, i * yTranslation_1);
                int nThis = nLeft / (n - i);
                nLeft -= nThis;
                if (isHorizontal) {
                    yTranslation_2 = size.height = paneHeight / nThis;
                } else {
                    xTranslation_2 = size.width = paneWidth / nThis;
                }
                int j = 0;
                while (true) {
                    JInternalFrame frame;
                    if ((frame = frames[k++]).isIcon() || frame.isMaximum()) {
                        continue;
                    }
                    frame.setSize(new Dimension(size));
                    frame.setLocation(new Point(point));
                    if (++j >= nThis) continue block6;
                    point.translate(xTranslation_2, yTranslation_2);
                }
            }
        }
    }

    @Override
    protected CommandProcessor createCommandProcessor() {
        return new InternalFrameCommandProcessor();
    }

    @Override
    protected void setActive(boolean active) {
        if (active) {
            this.map = new HashMap();
            this.top = new MDIDesktopPane();
            this.init = false;
        } else {
            this.map = null;
            this.top = null;
        }
    }

    class InternalFrameCommandProcessor
    extends PageManager.PageManagerCommandProcessor {
        InternalFrameCommandProcessor() {
            super(InternalFramePageManager.this);
        }

        public void onCascade() {
            InternalFramePageManager.this.arrange(-3);
        }

        public void onTileHorizontally() {
            InternalFramePageManager.this.arrange(-4);
        }

        public void onTileVertically() {
            InternalFramePageManager.this.arrange(-5);
        }

        public void onIconizeAll() {
            JInternalFrame[] frames = InternalFramePageManager.this.top.getAllFrames();
            for (int i = 0; i < frames.length; ++i) {
                JInternalFrame frame = frames[i];
                try {
                    if (frame.isIcon()) continue;
                    frame.setIcon(true);
                    continue;
                }
                catch (PropertyVetoException x) {
                    // empty catch block
                }
            }
        }

        private boolean hasOpenPages() {
            JInternalFrame[] frames = InternalFramePageManager.this.top.getAllFrames();
            for (int i = 0; i < frames.length; ++i) {
                if (frames[i].isIcon()) continue;
                return true;
            }
            return false;
        }

        public void enableCascade(CommandState state) {
            state.setEnabled(this.hasOpenPages());
        }

        public void enableTileVertically(CommandState state) {
            state.setEnabled(this.hasOpenPages());
        }

        public void enableTileHorizontally(CommandState state) {
            state.setEnabled(this.hasOpenPages());
        }

        public void enableIconizeAll(CommandState state) {
            state.setEnabled(this.hasOpenPages());
        }
    }

    private class FrameWithContext
    extends JInternalFrame {
        private PageContext context;

        FrameWithContext(PageContext context) {
            super(context.getTitle(), true, true, true, true);
            this.context = context;
            this.setFrameIcon(context.getIcon());
            this.setDefaultCloseOperation(0);
            Component c = context.getPage();
            if (c instanceof Container) {
                this.setContentPane((Container)c);
            } else {
                this.getContentPane().add(c);
            }
        }

        @Override
        protected void fireInternalFrameEvent(int id) {
            switch (id) {
                case 25552: {
                    ManagedPage mp = InternalFramePageManager.this.getManagedPage(this.context.getPage());
                    if (mp != null) {
                        mp.pageIconized();
                    }
                    InternalFramePageManager.this.firePageEvent(this.context, 4002);
                    InternalFramePageManager.this.getCommandProcessor().setChanged();
                    break;
                }
                case 25553: {
                    ManagedPage mp = InternalFramePageManager.this.getManagedPage(this.context.getPage());
                    if (mp != null) {
                        mp.pageDeiconized();
                    }
                    InternalFramePageManager.this.firePageEvent(this.context, 4003);
                    InternalFramePageManager.this.getCommandProcessor().setChanged();
                    break;
                }
                case 25550: {
                    InternalFramePageManager.this.close(this.context);
                    break;
                }
                case 25554: {
                    InternalFramePageManager.this.fireSelectionChanged(this.context);
                }
            }
            super.fireInternalFrameEvent(id);
        }
    }

    protected class MDIDesktopPane
    extends JDesktopPane
    implements HasPopupItems {
        protected MDIDesktopPane() {
        }

        @Override
        public void doLayout() {
            super.doLayout();
            if (!InternalFramePageManager.this.init) {
                InternalFramePageManager.this.arrange(-3);
                InternalFramePageManager.this.init = true;
            }
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
            if (source == this) {
                CommandTargetManager cm = Application.getApplication().getCommandTargetManager();
                JMenuItem cascade = new JMenuItem("Cascade");
                cascade.setMnemonic('C');
                cascade.setActionCommand("cascade");
                cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)cascade));
                menu.add(cascade);
                JMenuItem tileV = new JMenuItem("Tile Vertically");
                tileV.setMnemonic('V');
                tileV.setActionCommand("tileVertically");
                cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)tileV));
                menu.add(tileV);
                JMenuItem tileH = new JMenuItem("Tile Horizontally");
                tileH.setMnemonic('H');
                tileH.setActionCommand("tileHorizontally");
                cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)tileH));
                menu.add(tileH);
                JMenuItem close = new JMenuItem("Close All");
                close.setMnemonic('A');
                close.setActionCommand("closeAllPages");
                cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)close));
                menu.add(close);
            } else {
                InternalFramePageManager.this.modifyPopupMenu(menu, source, p);
            }
            return menu;
        }
    }
}

