/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.vehicles.GFtpProtocolInfo;
import diskCacheV111.vehicles.GFtpTransferStartedMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Random;
import org.dcache.ftp.BlockLog;
import org.dcache.ftp.ConnectionMonitor;
import org.dcache.ftp.DigestThread;
import org.dcache.ftp.DirectDigestThread;
import org.dcache.ftp.ErrorListener;
import org.dcache.ftp.FTPException;
import org.dcache.ftp.Mode;
import org.dcache.ftp.ModeE;
import org.dcache.ftp.ModeS;
import org.dcache.ftp.ModeX;
import org.dcache.ftp.Multiplexer;
import org.dcache.ftp.Role;
import org.dcache.pool.movers.ChecksumMover;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.FileRepositoryChannel;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.dcache.util.NetworkUtils;
import org.dcache.util.PortRange;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GFtpProtocol_2_nio
implements ConnectionMonitor,
MoverProtocol,
ChecksumMover,
ErrorListener {
    private static final Logger _log = LoggerFactory.getLogger(GFtpProtocol_2_nio.class);
    private static final Logger _logSpaceAllocation = LoggerFactory.getLogger((String)("logger.dev.org.dcache.poolspacemonitor." + GFtpProtocol_2_nio.class.getName()));
    public static final long SPACE_INC = 0x3200000L;
    public static final String READ_AHEAD_KEY = "gsiftpReadAhead";
    public static final int MODE_S_DEFAULT_BLOCK_SIZE = 524288;
    public static final int MODE_E_DEFAULT_BLOCK_SIZE = 131072;
    public static final int MODE_X_DEFAULT_BLOCK_SIZE = 131072;
    protected CellEndpoint _cell;
    protected RepositoryChannel _fileChannel;
    protected BlockLog _blockLog;
    protected ChecksumFactory _checksumFactory;
    protected MessageDigest _digest;
    protected Role _role;
    protected long _bytesTransferred;
    protected long _reservedSpace;
    protected long _spaceUsed;
    protected long _transferStarted;
    protected long _lastTransferred;
    protected Allocator _allocator;
    protected Multiplexer _multiplexer;
    protected String _status;
    protected PortRange _portRange;
    protected Integer _blockSize;
    protected boolean _allowPassivePool;
    protected boolean _verboseLogging;
    protected boolean _inProgress;
    private static Random _random = new Random();

    public GFtpProtocol_2_nio(CellEndpoint cell) {
        this._cell = cell;
        String range = System.getProperty("org.globus.tcp.port.range");
        this._portRange = range != null ? PortRange.valueOf((String)range) : new PortRange(0);
        if (this._cell != null) {
            Args args = this._cell.getArgs();
            if (args.hasOption("ftpProxyPassive")) {
                boolean bl = this._allowPassivePool = !Boolean.parseBoolean(args.getOpt("ftpProxyPassive"));
            }
            if (args.hasOption("gsiftpBlockSize")) {
                this._blockSize = Integer.valueOf(args.getOpt("gsiftpBlockSize"));
            }
        }
    }

    protected Mode createMode(String mode, Role role, RepositoryChannel fileChannel) throws IOException {
        switch (Character.toUpperCase(mode.charAt(0))) {
            case 'S': {
                int blockSize = this._blockSize == null ? 524288 : this._blockSize;
                return new ModeS(role, fileChannel, this, blockSize);
            }
            case 'E': {
                int blockSize = this._blockSize == null ? 131072 : this._blockSize;
                return new ModeE(role, fileChannel, this, blockSize);
            }
            case 'X': {
                int blockSize = this._blockSize == null ? 131072 : this._blockSize;
                return new ModeX(role, fileChannel, this, blockSize);
            }
        }
        throw new IllegalArgumentException("Unknown mode");
    }

    protected DigestThread createDigestThread() {
        if (this._digest == null) {
            return null;
        }
        return new DirectDigestThread(this._fileChannel, this._blockLog, this._digest);
    }

    @Override
    public void say(String str) {
        _log.info(str);
    }

    @Override
    public void esay(String str) {
        _log.error(str);
    }

    @Override
    public void esay(Throwable t) {
        _log.error(t.toString());
    }

    public String toString() {
        return "SU=" + this._spaceUsed + ";SA=" + this._reservedSpace + ";S=" + this._status;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transfer(RepositoryChannel fileChannel, Role role, Mode mode, Allocator allocator) throws Exception {
        this._role = role;
        this._bytesTransferred = 0L;
        this._blockLog = new BlockLog(this);
        this._fileChannel = fileChannel;
        this._allocator = allocator;
        this._reservedSpace = 0L;
        this._spaceUsed = 0L;
        this._status = "None";
        DigestThread digestThread = null;
        this._multiplexer = new Multiplexer(this);
        try {
            this._inProgress = true;
            digestThread = this.createDigestThread();
            if (digestThread != null) {
                Object o = this._cell.getDomainContext().get(READ_AHEAD_KEY);
                if (o != null && ((String)o).length() > 0) {
                    try {
                        digestThread.setReadAhead(Long.parseLong((String)o));
                    }
                    catch (NumberFormatException e) {
                        this.esay("Failed parsing read ahead: " + e.getMessage());
                    }
                }
                this.say("Initiated checksum computation thread");
                digestThread.start();
            }
            this._multiplexer.add(mode);
            this.say("Entering event loop");
            this._multiplexer.loop();
            this._inProgress = false;
            this._blockLog.setEof();
            this.say("Left event loop and closing channels");
        }
        catch (ClosedByInterruptException e) {
            try {
                Thread.interrupted();
                throw new InterruptedException();
                catch (InterruptedException | FTPException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.esay(e3);
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                this._inProgress = false;
                this._blockLog.setEof();
                this.say("Left event loop and closing channels");
                this._multiplexer.close();
                if (digestThread != null) {
                    digestThread.join();
                }
                long amount = this.getBytesTransferred();
                long time = this.getTransferTime();
                if (time > 0L) {
                    this.say(String.format("Transfer finished: %d bytes transferred in %.2f seconds = %.3f MB/s", amount, (double)time / 1000.0, 1000.0 * (double)amount / (double)(time * 1024L * 1024L)));
                    throw throwable;
                }
                this.say(String.format("Transfer finished: %d bytes transferred in less than 1 ms", amount));
                throw throwable;
            }
        }
        this._multiplexer.close();
        if (digestThread != null) {
            digestThread.join();
        }
        long amount = this.getBytesTransferred();
        long time = this.getTransferTime();
        if (time > 0L) {
            this.say(String.format("Transfer finished: %d bytes transferred in %.2f seconds = %.3f MB/s", amount, (double)time / 1000.0, 1000.0 * (double)amount / (double)(time * 1024L * 1024L)));
        } else {
            this.say(String.format("Transfer finished: %d bytes transferred in less than 1 ms", amount));
        }
        if (digestThread != null && digestThread.getLastError() != null) {
            this.esay(digestThread.getLastError());
            throw digestThread.getLastError();
        }
        if (this._blockLog.isComplete()) return;
        throw new CacheException(44, "Incomplete file detected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runIO(FileAttributes fileAttributes, RepositoryChannel fileChannel, ProtocolInfo protocol, Allocator allocator, IoMode access) throws Exception {
        if (!(protocol instanceof GFtpProtocolInfo)) {
            throw new CacheException(44, "Protocol info not of type GFtpProtocolInfo");
        }
        GFtpProtocolInfo gftpProtocolInfo = (GFtpProtocolInfo)protocol;
        Role role = access == IoMode.WRITE ? Role.Receiver : Role.Sender;
        int version = gftpProtocolInfo.getMajorVersion();
        String host = gftpProtocolInfo.getSocketAddress().getAddress().getHostAddress();
        int port = gftpProtocolInfo.getSocketAddress().getPort();
        int bufferSize = gftpProtocolInfo.getBufferSize();
        int parallelism = gftpProtocolInfo.getParallelStart();
        long offset = gftpProtocolInfo.getOffset();
        long size = gftpProtocolInfo.getSize();
        boolean passive = gftpProtocolInfo.getPassive() && this._allowPassivePool;
        this.say(MessageFormat.format("version={0}, role={1}, mode={2}, host={3}:{4,number,#}, buffer={5}, passive={6}, parallelism={7}", new Object[]{version, role, gftpProtocolInfo.getMode(), host, port, bufferSize, passive, parallelism}));
        if (gftpProtocolInfo.getPassive() && version == 1) {
            throw new CacheException(44, "Internal error: Cannot do passive transfer with mover protocol version 1.");
        }
        if (this._checksumFactory != null) {
            ChecksumFactory factory = this.getChecksumFactory(gftpProtocolInfo);
            if (factory != null) {
                this._checksumFactory = factory;
            }
            this._digest = this._checksumFactory.create();
        }
        this._lastTransferred = this._transferStarted = System.currentTimeMillis();
        Mode mode = this.createMode(gftpProtocolInfo.getMode(), role, fileChannel);
        mode.setBufferSize(bufferSize);
        if (version == 2) {
            GFtpTransferStartedMessage message;
            if (passive) {
                ServerSocketChannel channel = ServerSocketChannel.open();
                if (bufferSize > 0) {
                    channel.socket().setReceiveBufferSize(bufferSize);
                }
                this._portRange.bind(channel.socket());
                InetAddress clientAddress = InetAddress.getByName(gftpProtocolInfo.getClientAddress());
                InetAddress localAddress = NetworkUtils.getLocalAddress((InetAddress)clientAddress);
                String localHostName = localAddress.getCanonicalHostName();
                int localPort = channel.socket().getLocalPort();
                message = new GFtpTransferStartedMessage(fileAttributes.getPnfsId().getId(), localHostName, localPort);
                mode.setPassive(channel);
            } else {
                message = new GFtpTransferStartedMessage(fileAttributes.getPnfsId().getId());
            }
            CellPath path = new CellPath(gftpProtocolInfo.getDoorCellName(), gftpProtocolInfo.getDoorCellDomainName());
            this._cell.sendMessage(new CellMessage(path, (Serializable)((Object)message)));
        }
        if (!passive) {
            try {
                mode.setActive(new InetSocketAddress(host, port));
            }
            catch (UnresolvedAddressException e) {
                throw new CacheException("Failed to resolve " + host);
            }
        }
        switch (Character.toUpperCase(gftpProtocolInfo.getMode().charAt(0))) {
            case 'E': {
                if (role != Role.Receiver || passive) break;
                parallelism = 1;
                break;
            }
            case 'S': {
                parallelism = 1;
            }
        }
        mode.setParallelism(parallelism);
        if (role == Role.Sender) {
            String err;
            long fileSize = fileChannel.size();
            if (offset < 0L) {
                err = "prm_offset is " + offset;
                this.esay(err);
                throw new IllegalArgumentException(err);
            }
            if (size < 0L) {
                err = "prm_offset is " + size;
                this.esay(err);
                throw new IllegalArgumentException(err);
            }
            if (offset + size > fileSize) {
                err = "invalid prm_offset=" + offset + " and prm_size " + size + " for file of size " + fileSize;
                this.esay(err);
                throw new IllegalArgumentException(err);
            }
            mode.setPartialRetrieveParameters(offset, size);
        }
        try {
            this.transfer(fileChannel, role, mode, allocator);
        }
        finally {
            gftpProtocolInfo.setBytesTransferred(this.getBytesTransferred());
            gftpProtocolInfo.setTransferTime(this.getTransferTime());
        }
    }

    public void setVerboseLogging(boolean value) {
        this._verboseLogging = value;
    }

    public boolean getVerboseLogging() {
        return this._verboseLogging;
    }

    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    public long getTransferTime() {
        return (this._inProgress ? System.currentTimeMillis() : this._lastTransferred) - this._transferStarted;
    }

    public long getLastTransferred() {
        return this._lastTransferred;
    }

    private ChecksumFactory getChecksumFactory(GFtpProtocolInfo protocol) {
        String type = protocol.getChecksumType();
        if (type == null || type.equals("Unknown")) {
            return null;
        }
        try {
            return ChecksumFactory.getFactory((ChecksumType)ChecksumType.getChecksumType((String)type));
        }
        catch (NoSuchAlgorithmException e) {
            this.esay("CRC Algorithm is not supported: " + type);
            return null;
        }
    }

    public void enableTransferChecksum(ChecksumType suggestedAlgorithm) throws NoSuchAlgorithmException {
        this._checksumFactory = ChecksumFactory.getFactory((ChecksumType)suggestedAlgorithm);
    }

    public Checksum getExpectedChecksum() {
        return null;
    }

    public Checksum getActualChecksum() {
        return this._digest == null ? null : this._checksumFactory.create(this._digest.digest());
    }

    @Override
    public void receivedBlock(long position, long size) throws Exception {
        if (this._role != Role.Receiver) {
            throw new IllegalStateException("Only receivers can receive");
        }
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException("Position and size must be non-negative");
        }
        if (position + size > this._spaceUsed) {
            throw new IllegalArgumentException("Must call preallocate before receiving data");
        }
        if (this._verboseLogging) {
            this.say("received " + position + " " + size);
        }
        this._blockLog.addBlock(position, size);
        this._bytesTransferred += size;
        this._lastTransferred = System.currentTimeMillis();
    }

    @Override
    public void sentBlock(long position, long size) throws Exception {
        if (this._role != Role.Sender) {
            throw new IllegalStateException("Only senders can send");
        }
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException("Position and size must be non-negative");
        }
        if (this._verboseLogging) {
            this.say("send " + position + " " + size);
        }
        this._blockLog.addBlock(position, size);
        this._bytesTransferred += size;
        this._lastTransferred = System.currentTimeMillis();
    }

    @Override
    public void preallocate(long position) throws InterruptedException {
        if (this._role != Role.Receiver) {
            throw new IllegalStateException("Only receivers can allocate space");
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Position must be positive");
        }
        if (position > this._reservedSpace) {
            long additional = Math.max(position - this._reservedSpace, 0x3200000L);
            this._status = "WaitingForSpace(" + additional + ")";
            _logSpaceAllocation.debug("ALLOC: " + additional);
            this._allocator.allocate(additional);
            this._status = "None";
            this._reservedSpace += additional;
        }
        this._spaceUsed = Math.max(this._spaceUsed, position);
    }

    public static String getOption(Args args, String name, String defaultValue) {
        String value = args.getOpt(name);
        return value == null ? defaultValue : value;
    }

    public static void help() {
        System.out.println("Usage: mover -l [OPTION]... ROLE FILE");
        System.out.println("       mover [OPTION]... ROLE FILE HOSTNAME");
        System.out.println("where ROLE is either -s or -r");
        System.out.println("  -port=PORT");
        System.out.println("  -buffer=SIZE");
        System.out.println("  -streams=NUMBER");
        System.out.println("  -offset=BYTES");
        System.out.println("  -size=BYTES");
        System.out.println("  -mode=(S|E|X)");
        System.out.println("  -digest=ALGORITHM");
        System.out.println("  -verbose=false|true");
        System.exit(1);
    }

    public static void main(String[] a) {
        try {
            Args args = new Args(a);
            int port = Integer.valueOf(GFtpProtocol_2_nio.getOption(args, "port", "2288"));
            int bufferSize = Integer.valueOf(GFtpProtocol_2_nio.getOption(args, "buffer", "0"));
            int parallelism = Integer.valueOf(GFtpProtocol_2_nio.getOption(args, "streams", "1"));
            long offset = Long.valueOf(GFtpProtocol_2_nio.getOption(args, "offset", "0"));
            long size = Long.valueOf(GFtpProtocol_2_nio.getOption(args, "size", "0"));
            String digest = GFtpProtocol_2_nio.getOption(args, "digest", "");
            boolean verbose = Boolean.valueOf(GFtpProtocol_2_nio.getOption(args, "verbose", "false"));
            Role role = Role.Receiver;
            if (args.isOneCharOption('r')) {
                role = Role.Receiver;
            } else if (args.isOneCharOption('s')) {
                role = Role.Sender;
            } else {
                GFtpProtocol_2_nio.help();
            }
            GFtpProtocol_2_nio mover = new GFtpProtocol_2_nio(null);
            FileRepositoryChannel fileChannel = new FileRepositoryChannel(args.argv(0), role == Role.Sender ? "r" : "rw");
            Mode mode = mover.createMode(GFtpProtocol_2_nio.getOption(args, "mode", "S"), role, (RepositoryChannel)fileChannel);
            if (args.isOneCharOption('l')) {
                if (args.argc() != 1) {
                    GFtpProtocol_2_nio.help();
                }
                ServerSocketChannel channel = ServerSocketChannel.open();
                if (bufferSize > 0) {
                    channel.socket().setReceiveBufferSize(bufferSize);
                }
                channel.socket().bind(new InetSocketAddress(port));
                mode.setPassive(channel);
            } else {
                if (args.argc() != 2) {
                    GFtpProtocol_2_nio.help();
                }
                mode.setActive(new InetSocketAddress(args.argv(1), port));
            }
            if (digest.length() > 0 && role != Role.Receiver) {
                System.err.println("Digest can only be computed on receive");
                System.exit(1);
            }
            if (size == 0L) {
                size = fileChannel.size() - offset;
            }
            mode.setParallelism(parallelism);
            mode.setPartialRetrieveParameters(offset, size);
            if (digest.length() > 0) {
                mover.enableTransferChecksum(ChecksumType.getChecksumType((String)digest));
            }
            mover.setVerboseLogging(verbose);
            mover.transfer((RepositoryChannel)fileChannel, role, mode, null);
            if (digest.length() > 0) {
                System.out.println(mover.getActualChecksum());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

