/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.ftp;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.dcache.ftp.ErrorListener;
import org.dcache.ftp.MultiplexerListener;

public class Multiplexer
implements ErrorListener {
    protected boolean _shutdown = false;
    protected Selector _selector = Selector.open();
    protected ErrorListener _errorListener;

    public Multiplexer(ErrorListener errorListener) throws IOException {
        this._errorListener = errorListener;
    }

    @Override
    public void say(String msg) {
        if (this._errorListener != null) {
            this._errorListener.say(msg);
        }
    }

    @Override
    public void esay(String msg) {
        if (this._errorListener != null) {
            this._errorListener.esay(msg);
        }
    }

    @Override
    public void esay(Throwable t) {
        if (this._errorListener != null) {
            this._errorListener.esay(t);
        }
    }

    public void loop() throws Exception {
        while (!this._shutdown) {
            this._selector.select();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            for (SelectionKey key : this._selector.selectedKeys()) {
                MultiplexerListener listener = (MultiplexerListener)key.attachment();
                if (key.isValid() && key.isConnectable()) {
                    listener.connect(this, key);
                }
                if (key.isValid() && key.isAcceptable()) {
                    listener.accept(this, key);
                }
                if (key.isValid() && key.isReadable()) {
                    listener.read(this, key);
                }
                if (!key.isValid() || !key.isWritable()) continue;
                listener.write(this, key);
            }
            this._selector.selectedKeys().clear();
        }
    }

    public SelectionKey register(MultiplexerListener listener, int op, SelectableChannel channel) throws IOException {
        return channel.register(this._selector, op, listener);
    }

    public void add(MultiplexerListener listener) throws Exception {
        listener.register(this);
    }

    public void close() throws IOException {
        for (SelectionKey key : this._selector.keys()) {
            key.channel().close();
        }
        this._selector.selectNow();
        this._selector.close();
    }

    public void shutdown() {
        this.say("Multiplexer shutting down");
        this._shutdown = true;
    }
}

