/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.ftp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.regex.Pattern;
import org.dcache.ftp.AbstractMultiplexerListener;
import org.dcache.ftp.ConnectionMonitor;
import org.dcache.ftp.FTPException;
import org.dcache.ftp.Mode;
import org.dcache.ftp.Multiplexer;
import org.dcache.ftp.Role;
import org.dcache.pool.repository.RepositoryChannel;

public class ModeX
extends Mode {
    public static final int HEADER_LENGTH = 25;
    public static final int EOF_DESCRIPTOR = 64;
    public static final int EOD_DESCRIPTOR = 8;
    public static final int SENDER_CLOSES_THIS_STREAM_DESCRIPTOR = 4;
    public static final int KNOWN_DESCRIPTORS = 76;
    private final int _blockSize;
    private long _currentPosition = this.getStartPosition();
    private long _currentCount = this.getSize();
    private boolean _eof = false;
    private int _closing = 0;
    private static Charset _ascii = Charset.forName("ascii");
    private static CharsetEncoder _encoder = _ascii.newEncoder();
    private static CharsetDecoder _decoder = _ascii.newDecoder();

    public ModeX(Role role, RepositoryChannel file, ConnectionMonitor monitor, int blockSize) throws IOException {
        super(role, file, monitor);
        this._blockSize = blockSize;
    }

    @Override
    public void newConnection(Multiplexer multiplexer, SocketChannel socket) throws Exception {
        switch (this._role) {
            case Sender: {
                multiplexer.add(new Sender(socket));
                break;
            }
            case Receiver: {
                if (this._eof) {
                    socket.close();
                    break;
                }
                multiplexer.add(new Receiver(socket));
            }
        }
    }

    class Receiver
    extends AbstractMultiplexerListener {
        protected SocketChannel _socket;
        protected ReceiverState _state;
        protected long _position;
        protected long _count;
        protected int _flags;
        protected ByteBuffer _header = ByteBuffer.allocate(25);
        protected ByteBuffer _command = ByteBuffer.allocate(128);

        public Receiver(SocketChannel socket) {
            this._socket = socket;
            this._count = 0L;
            this._position = 0L;
            this._flags = 0;
            this._state = ReceiverState.READ_HEADER;
            this._command.limit(0);
        }

        private void addCommand(String s) {
            CharBuffer buffer = CharBuffer.allocate(s.length() + 1);
            buffer.put(s);
            buffer.put('\n');
            buffer.flip();
            this._command.compact();
            _encoder.encode(buffer, this._command, true);
            this._command.flip();
        }

        @Override
        public void register(Multiplexer multiplexer) throws IOException {
            multiplexer.register(this, 4, this._socket);
            this.addCommand("READY");
        }

        @Override
        public void write(Multiplexer multiplexer, SelectionKey key) throws Exception {
            try {
                this._socket.write(this._command);
                if (this._command.position() == this._command.limit()) {
                    if (this._state == ReceiverState.SEND_BYE) {
                        ModeX.this.close(multiplexer, key, true);
                    } else {
                        key.interestOps(1);
                    }
                }
            }
            catch (ClosedChannelException e) {
                if (this._state == ReceiverState.SEND_BYE) {
                    ModeX.this.close(multiplexer, key, true);
                }
                throw e;
            }
        }

        @Override
        public void read(Multiplexer multiplexer, SelectionKey key) throws Exception {
            switch (this._state) {
                case READ_HEADER: {
                    long nbytes = this._socket.read(this._header);
                    if (nbytes == -1L) {
                        throw new FTPException("Stream ended before EOD");
                    }
                    if (this._header.position() < this._header.limit()) {
                        return;
                    }
                    this._header.rewind();
                    this._flags = this._header.get();
                    this._count = this._header.getLong();
                    this._position = this._header.getLong();
                    this._header.clear();
                    if ((this._flags & 0xFFFFFFB3) != 0) {
                        throw new FTPException("Received block with unknown descriptor (" + this._flags + ")");
                    }
                    if ((this._flags & 0x40) != 0) {
                        ModeX.this._eof = true;
                    }
                    if (this._count == 0L) {
                        if ((this._flags & 8) == 0) break;
                        key.interestOps(4);
                        this.addCommand("BYE");
                        this._state = ReceiverState.SEND_BYE;
                        break;
                    }
                    ModeX.this._monitor.preallocate(this._position + this._count);
                    this._state = ReceiverState.READ_DATA;
                }
                case READ_DATA: {
                    long nbytes = ModeX.this.transferFrom(this._socket, this._position, this._count);
                    if (nbytes == -1L) {
                        throw new FTPException("Stream was closed in the middle of a block");
                    }
                    ModeX.this._monitor.receivedBlock(this._position, nbytes);
                    this._position += nbytes;
                    this._count -= nbytes;
                    if (this._count != 0L) break;
                    if ((this._flags & 8) != 0) {
                        key.interestOps(4);
                        this.addCommand("BYE");
                        this._state = ReceiverState.SEND_BYE;
                        break;
                    }
                    this._state = ReceiverState.READ_HEADER;
                }
            }
        }
    }

    private class Sender
    extends AbstractMultiplexerListener {
        protected SocketChannel _socket;
        protected SenderState _state;
        protected long _position;
        protected long _count;
        protected boolean _closeAtNextBlock;
        protected ByteBuffer _header = ByteBuffer.allocate(25);
        protected ByteBuffer _command = ByteBuffer.allocate(128);
        protected CharBuffer _decodedCommand = CharBuffer.allocate(128);

        public Sender(SocketChannel socket) {
            this._socket = socket;
            this._state = SenderState.WAIT_READY;
            this._closeAtNextBlock = false;
        }

        @Override
        public void register(Multiplexer multiplexer) throws IOException {
            multiplexer.register(this, 1, this._socket);
        }

        @Override
        public void read(Multiplexer multiplexer, SelectionKey key) throws Exception {
            char c;
            if (!this._command.hasRemaining()) {
                throw new FTPException("Command buffer full");
            }
            long nbytes = this._socket.read(this._command);
            if (nbytes == -1L) {
                if (this._state == SenderState.WAIT_READY) {
                    ModeX.this.close(multiplexer, key, ModeX.this._eof);
                    return;
                }
                throw new FTPException("Lost connection");
            }
            this._command.flip();
            _decoder.decode(this._command, this._decodedCommand, false);
            this._command.compact();
            StringBuffer line = new StringBuffer();
            this._decodedCommand.flip();
            do {
                if (!this._decodedCommand.hasRemaining()) {
                    this._decodedCommand.limit(this._decodedCommand.capacity());
                    return;
                }
                c = this._decodedCommand.get();
                line.append(c);
            } while (c != '\n');
            this._decodedCommand.compact();
            String[] arg = Pattern.compile("\\s").split(line);
            if (arg.length == 0) {
                throw new FTPException("Empty command received (protocol violation)");
            }
            String cmd = arg[0];
            if (cmd.equals("READY") && this._state == SenderState.WAIT_READY) {
                this._state = SenderState.NEXT_BLOCK;
                key.interestOps(5);
            } else if (cmd.equals("BYE") && this._state == SenderState.WAIT_BYE) {
                ModeX.this.close(multiplexer, key, ModeX.this._eof);
            } else if (cmd.equals("CLOSE")) {
                this._closeAtNextBlock = true;
            } else {
                if (cmd.equals("RESEND")) {
                    throw new FTPException("RESEND is not implemented");
                }
                throw new FTPException("Unexpected command '" + cmd + "' in state " + (Object)((Object)this._state));
            }
        }

        @Override
        public void write(Multiplexer multiplexer, SelectionKey key) throws Exception {
            switch (this._state) {
                case NEXT_BLOCK: {
                    byte descriptor;
                    this._position = ModeX.this._currentPosition;
                    this._count = Math.min(ModeX.this._currentCount, (long)ModeX.this._blockSize);
                    if (this._count == 0L) {
                        descriptor = 76;
                        ModeX.this._closing++;
                        ModeX.this._eof = true;
                    } else if (this._closeAtNextBlock && ModeX.this._opened > ModeX.this._closing + 1) {
                        descriptor = 12;
                        ModeX.this._closing++;
                        this._count = 0L;
                    } else {
                        descriptor = 0;
                        ModeX.this._currentPosition += this._count;
                        ModeX.this._currentCount -= this._count;
                    }
                    this._header.clear();
                    this._header.put(descriptor);
                    this._header.putLong(this._count);
                    this._header.putLong(this._position);
                    this._header.putLong(0L);
                    this._header.flip();
                    this._state = SenderState.SEND_HEADER;
                }
                case SEND_HEADER: {
                    this._socket.write(this._header);
                    if (this._header.position() < this._header.limit()) break;
                    if (this._count == 0L) {
                        key.interestOps(1);
                        this._state = SenderState.WAIT_BYE;
                        break;
                    }
                    this._state = SenderState.SEND_DATA;
                }
                case SEND_DATA: {
                    long nbytes = ModeX.this.transferTo(this._position, this._count, this._socket);
                    ModeX.this._monitor.sentBlock(this._position, nbytes);
                    this._position += nbytes;
                    this._count -= nbytes;
                    if (this._count != 0L) break;
                    this._state = SenderState.NEXT_BLOCK;
                }
            }
        }
    }

    static enum ReceiverState {
        SEND_BYE,
        READ_HEADER,
        READ_DATA;

    }

    static enum SenderState {
        WAIT_READY,
        WAIT_BYE,
        NEXT_BLOCK,
        SEND_HEADER,
        SEND_DATA;

    }
}

