/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.ftp;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.dcache.ftp.AbstractMultiplexerListener;
import org.dcache.ftp.ConnectionMonitor;
import org.dcache.ftp.Mode;
import org.dcache.ftp.Multiplexer;
import org.dcache.ftp.Role;
import org.dcache.pool.repository.RepositoryChannel;

public class ModeS
extends Mode {
    private final int _blockSize;

    public ModeS(Role role, RepositoryChannel file, ConnectionMonitor monitor, int blockSize) throws IOException {
        super(role, file, monitor);
        this._blockSize = blockSize;
    }

    @Override
    public void newConnection(Multiplexer multiplexer, SocketChannel socket) throws Exception {
        switch (this._role) {
            case Sender: {
                multiplexer.add(new Sender(socket));
                break;
            }
            case Receiver: {
                multiplexer.add(new Receiver(socket));
            }
        }
    }

    private class Receiver
    extends AbstractMultiplexerListener {
        protected SocketChannel _socket;
        protected long _position;

        public Receiver(SocketChannel socket) {
            this._socket = socket;
            this._position = 0L;
        }

        @Override
        public void register(Multiplexer multiplexer) throws IOException {
            multiplexer.register(this, 1, this._socket);
        }

        @Override
        public void read(Multiplexer multiplexer, SelectionKey key) throws Exception {
            ModeS.this._monitor.preallocate(this._position + (long)ModeS.this._blockSize);
            long nbytes = ModeS.this.transferFrom(this._socket, this._position, ModeS.this._blockSize);
            if (nbytes == -1L) {
                ModeS.this.close(multiplexer, key, true);
            } else {
                ModeS.this._monitor.receivedBlock(this._position, nbytes);
                this._position += nbytes;
            }
        }
    }

    private class Sender
    extends AbstractMultiplexerListener {
        protected SocketChannel _socket;
        protected long _position;
        protected long _count;

        public Sender(SocketChannel socket) {
            this._socket = socket;
            this._position = ModeS.this.getStartPosition();
            this._count = ModeS.this.getSize();
        }

        @Override
        public void register(Multiplexer multiplexer) throws IOException {
            multiplexer.register(this, 4, this._socket);
        }

        @Override
        public void write(Multiplexer multiplexer, SelectionKey key) throws Exception {
            long nbytes = ModeS.this.transferTo(this._position, this._count, this._socket);
            ModeS.this._monitor.sentBlock(this._position, nbytes);
            this._position += nbytes;
            this._count -= nbytes;
            if (this._count == 0L) {
                ModeS.this.close(multiplexer, key, true);
            }
        }
    }
}

