/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.ftp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.dcache.ftp.AbstractMultiplexerListener;
import org.dcache.ftp.ConnectionMonitor;
import org.dcache.ftp.FTPException;
import org.dcache.ftp.Mode;
import org.dcache.ftp.Multiplexer;
import org.dcache.ftp.Role;
import org.dcache.pool.repository.RepositoryChannel;

public class ModeE
extends Mode {
    public static final int HEADER_LENGTH = 17;
    public static final int EOR_DESCRIPTOR = 128;
    public static final int EOF_DESCRIPTOR = 64;
    public static final int SUSPECTED_ERROR_DESCRIPTOR = 32;
    public static final int RESTART_MARKER_DESCRIPTOR = 16;
    public static final int EOD_DESCRIPTOR = 8;
    public static final int SENDER_CLOSES_THIS_STREAM_DESCRIPTOR = 4;
    public static final int KNOWN_DESCRIPTORS = 76;
    private final int _blockSize;
    private long _currentPosition = this.getStartPosition();
    private long _currentCount = this.getSize();
    private long _eodc = 0L;

    public ModeE(Role role, RepositoryChannel file, ConnectionMonitor monitor, int blockSize) throws IOException {
        super(role, file, monitor);
        this._blockSize = blockSize;
    }

    @Override
    public void setPartialRetrieveParameters(long position, long size) {
        super.setPartialRetrieveParameters(position, size);
        this._currentPosition = this.getStartPosition();
        this._currentCount = this.getSize();
    }

    @Override
    public void newConnection(Multiplexer multiplexer, SocketChannel socket) throws Exception {
        switch (this._role) {
            case Sender: {
                multiplexer.add(new Sender(socket));
                break;
            }
            case Receiver: {
                multiplexer.add(new Receiver(socket));
            }
        }
    }

    class Receiver
    extends AbstractMultiplexerListener {
        protected SocketChannel _socket;
        protected long _count;
        protected long _position;
        protected int _flags;
        protected boolean _used;
        protected ByteBuffer _header = ByteBuffer.allocate(17);

        public Receiver(SocketChannel socket) {
            this._socket = socket;
            this._count = 0L;
            this._position = 0L;
            this._flags = 0;
            this._used = false;
        }

        @Override
        public void register(Multiplexer multiplexer) throws IOException {
            multiplexer.register(this, 1, this._socket);
        }

        @Override
        public void read(Multiplexer multiplexer, SelectionKey key) throws Exception {
            long nbytes;
            if (this._count == 0L) {
                nbytes = this._socket.read(this._header);
                if (nbytes == -1L) {
                    if (this._used) {
                        throw new FTPException("Stream ended before EOD");
                    }
                    ModeE.this.close(multiplexer, key, (long)ModeE.this._opened == ModeE.this._eodc);
                    return;
                }
                this._used = true;
                if (this._header.position() < this._header.limit()) {
                    return;
                }
                this._header.rewind();
                this._flags = this._header.get();
                this._count = this._header.getLong();
                this._position = this._header.getLong();
                this._header.clear();
                if ((this._flags & 0xFFFFFFB3) != 0) {
                    throw new FTPException("Received block with unknown descriptor (" + this._flags + ")");
                }
                if ((this._flags & 0x40) != 0) {
                    if (ModeE.this._eodc != 0L) {
                        throw new FTPException("Multible EODC received");
                    }
                    if (this._position <= 0L) {
                        throw new FTPException("Non-positive EODC received");
                    }
                    ModeE.this._eodc = (int)this._position;
                    this._position = 0L;
                    this._count = 0L;
                }
                if (this._count == 0L) {
                    if ((this._flags & 8) != 0) {
                        ModeE.this.close(multiplexer, key, (long)ModeE.this._opened == ModeE.this._eodc);
                    }
                    return;
                }
                ModeE.this._monitor.preallocate(this._position + this._count);
            }
            if ((nbytes = ModeE.this.transferFrom(this._socket, this._position, this._count)) == -1L) {
                throw new FTPException("Stream was closed in the middle of a block");
            }
            ModeE.this._monitor.receivedBlock(this._position, nbytes);
            this._position += nbytes;
            this._count -= nbytes;
            if (this._count == 0L && (this._flags & 8) != 0) {
                ModeE.this.close(multiplexer, key, (long)ModeE.this._opened == ModeE.this._eodc);
            }
        }
    }

    private class Sender
    extends AbstractMultiplexerListener {
        protected static final int PREPARE_BLOCK = 0;
        protected static final int SEND_HEADER = 1;
        protected static final int SEND_DATA = 2;
        protected SocketChannel _socket;
        protected int _state;
        protected long _position;
        protected long _count;
        protected boolean _sendEOF;
        protected ByteBuffer _header = ByteBuffer.allocate(17);

        public Sender(SocketChannel socket) {
            this._socket = socket;
            this._state = 0;
            this._sendEOF = ModeE.this._opened == 1;
        }

        @Override
        public void register(Multiplexer multiplexer) throws IOException {
            multiplexer.register(this, 4, this._socket);
        }

        @Override
        public void write(Multiplexer multiplexer, SelectionKey key) throws Exception {
            switch (this._state) {
                case 0: {
                    this._position = ModeE.this._currentPosition;
                    this._count = Math.min(ModeE.this._currentCount, (long)ModeE.this._blockSize);
                    ModeE.this._currentPosition += this._count;
                    ModeE.this._currentCount -= this._count;
                    this._header.clear();
                    if (this._count > 0L) {
                        this._header.put((byte)0);
                        this._header.putLong(this._count);
                        this._header.putLong(this._position);
                    } else if (this._sendEOF) {
                        if (!ModeE.this.waitForConnectionCompletion(key)) {
                            return;
                        }
                        this._header.put((byte)76);
                        this._header.putLong(0L);
                        this._header.putLong(ModeE.this._opened);
                    } else {
                        this._header.put((byte)12);
                        this._header.putLong(0L);
                        this._header.putLong(0L);
                    }
                    this._header.flip();
                    this._state = 1;
                }
                case 1: {
                    this._socket.write(this._header);
                    if (this._header.position() < this._header.limit()) break;
                    if (this._count == 0L) {
                        ModeE.this.close(multiplexer, key, true);
                        break;
                    }
                    this._state = 2;
                }
                case 2: {
                    long nbytes = ModeE.this.transferTo(this._position, this._count, this._socket);
                    ModeE.this._monitor.sentBlock(this._position, nbytes);
                    this._position += nbytes;
                    this._count -= nbytes;
                    if (this._count != 0L) break;
                    this._state = 0;
                }
            }
        }
    }
}

