/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.ftp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.HashMap;
import java.util.Map;
import org.dcache.ftp.AbstractMultiplexerListener;
import org.dcache.ftp.ConnectionMonitor;
import org.dcache.ftp.Direction;
import org.dcache.ftp.Multiplexer;
import org.dcache.ftp.Role;
import org.dcache.pool.repository.RepositoryChannel;

public abstract class Mode
extends AbstractMultiplexerListener {
    protected Role _role;
    protected Direction _direction;
    protected RepositoryChannel _file;
    protected ConnectionMonitor _monitor;
    private long _position;
    private long _size;
    private long _fileSize;
    private ByteBuffer _buffer = ByteBuffer.allocate(8192);
    private SocketAddress _address;
    private ServerSocketChannel _channel;
    private int _bufferSize;
    protected int _parallelism = 1;
    protected Map<SelectionKey, Integer> disabled = new HashMap<SelectionKey, Integer>();
    protected int _failed;
    protected int _opened;
    protected int _closed;

    public Mode(Role role, RepositoryChannel file, ConnectionMonitor monitor) throws IOException {
        this._fileSize = file.size();
        this._role = role;
        this._file = file;
        this._size = this._fileSize;
        this._monitor = monitor;
    }

    public void setPassive(ServerSocketChannel channel) {
        assert (this._address == null && this._channel == null && channel != null);
        this._direction = Direction.Incomming;
        this._channel = channel;
    }

    public void setActive(InetSocketAddress address) throws UnresolvedAddressException {
        assert (this._address == null && this._channel == null && address != null);
        if (address.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        this._direction = Direction.Outgoing;
        this._address = address;
    }

    public void setPartialRetrieveParameters(long position, long size) {
        if (this._position < 0L || size < 0L || position + size > this._fileSize) {
            throw new IllegalArgumentException();
        }
        this._position = position;
        this._size = size;
    }

    public void setBufferSize(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Buffer size must be non-negative");
        }
        this._bufferSize = value;
    }

    public void setParallelism(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Parallelism must be positive");
        }
        this._parallelism = value;
    }

    public long getStartPosition() {
        return this._position;
    }

    public long getSize() {
        return this._size;
    }

    protected long transferTo(long position, long count, SocketChannel socket) throws IOException {
        long tr = 0L;
        long pos = position;
        this._buffer.clear();
        while (tr < count) {
            this._buffer.limit((int)Math.min(count - tr, (long)this._buffer.capacity()));
            int nr = this._file.read(this._buffer, pos);
            if (nr < 0 && tr == 0L) {
                return -1L;
            }
            if (nr <= 0) break;
            this._buffer.flip();
            int nw = socket.write(this._buffer);
            tr += (long)nw;
            if (nw != nr) break;
            pos += (long)nw;
            this._buffer.clear();
        }
        return tr;
    }

    protected long transferFrom(SocketChannel socket, long position, long count) throws IOException {
        long tw = 0L;
        long pos = position;
        try {
            this._buffer.clear();
            while (tw < count) {
                this._buffer.limit((int)Math.min(count - tw, (long)this._buffer.capacity()));
                int nr = socket.read(this._buffer);
                if (nr < 0 && tw == 0L) {
                    return -1L;
                }
                if (nr <= 0) break;
                this._buffer.flip();
                int nw = this._file.write(this._buffer, pos);
                tw += (long)nw;
                if (nw != nr) break;
                pos += (long)nw;
                this._buffer.clear();
            }
            return tw;
        }
        catch (IOException x) {
            if (tw > 0L) {
                return tw;
            }
            throw x;
        }
    }

    protected void registerOutgoing(Multiplexer multiplexer) throws Exception {
        IOException lastException = null;
        for (int i = 0; i < this._parallelism; ++i) {
            SocketChannel channel = SocketChannel.open();
            try {
                channel.configureBlocking(false);
                if (this._bufferSize > 0) {
                    channel.socket().setReceiveBufferSize(this._bufferSize);
                    channel.socket().setSendBufferSize(this._bufferSize);
                }
                channel.socket().setKeepAlive(true);
                SelectionKey key = multiplexer.register(this, 8, channel);
                multiplexer.say("Connecting to " + this._address);
                if (!channel.connect(this._address)) continue;
                this.connect(multiplexer, key);
                continue;
            }
            catch (IOException e) {
                channel.close();
                lastException = e;
                multiplexer.esay(e.toString());
                ++this._failed;
                if (!this.allConnectionsEstablished()) continue;
                this.enableDisabledKeys();
            }
        }
        if (this._failed == this._parallelism) {
            throw lastException;
        }
    }

    protected void registerIncomming(Multiplexer multiplexer) throws IOException {
        this._channel.configureBlocking(false);
        multiplexer.say("Accepting connections on " + this._channel.socket().getLocalSocketAddress());
        multiplexer.register(this, 16, this._channel);
    }

    @Override
    public void register(Multiplexer multiplexer) throws Exception {
        assert (this._address != null || this._channel != null) : "Mode must be either set to passive or active.";
        switch (this._direction) {
            case Incomming: {
                this.registerIncomming(multiplexer);
                break;
            }
            case Outgoing: {
                this.registerOutgoing(multiplexer);
                break;
            }
        }
    }

    @Override
    public void accept(Multiplexer multiplexer, SelectionKey key) throws Exception {
        ServerSocketChannel server = (ServerSocketChannel)key.channel();
        SocketChannel channel = server.accept();
        if (channel != null) {
            Socket socket = channel.socket();
            ++this._opened;
            multiplexer.say("Opened " + socket);
            channel.configureBlocking(false);
            if (this._bufferSize > 0) {
                channel.socket().setSendBufferSize(this._bufferSize);
            }
            channel.socket().setKeepAlive(true);
            this.newConnection(multiplexer, channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Multiplexer multiplexer, SelectionKey key) throws Exception {
        try {
            SocketChannel channel = (SocketChannel)key.channel();
            if (channel.finishConnect()) {
                Socket socket = channel.socket();
                ++this._opened;
                multiplexer.say("Opened " + socket);
                this.newConnection(multiplexer, channel);
            }
        }
        catch (IOException e) {
            ++this._failed;
            if (this._failed == this._parallelism) {
                throw e;
            }
        }
        finally {
            if (this.allConnectionsEstablished()) {
                this.enableDisabledKeys();
            }
        }
    }

    protected void close(Multiplexer multiplexer, SelectionKey key, boolean mayShutdown) throws IOException {
        SocketChannel channel = (SocketChannel)key.channel();
        multiplexer.say("Closing " + channel.socket());
        key.cancel();
        channel.close();
        ++this._closed;
        if (mayShutdown && this._closed == this._opened) {
            multiplexer.shutdown();
        }
    }

    private void enableDisabledKeys() {
        for (Map.Entry<SelectionKey, Integer> e : this.disabled.entrySet()) {
            e.getKey().interestOps(e.getValue());
        }
        this.disabled.clear();
    }

    private void disableKey(SelectionKey key) {
        if (!this.disabled.containsKey(key)) {
            this.disabled.put(key, key.interestOps());
            key.interestOps(0);
        }
    }

    private boolean allConnectionsEstablished() {
        return this._opened + this._failed >= this._parallelism;
    }

    protected boolean waitForConnectionCompletion(SelectionKey key) {
        if (this._direction != Direction.Outgoing) {
            throw new IllegalArgumentException("Call is only valid for outgoing connections");
        }
        if (this.allConnectionsEstablished()) {
            return true;
        }
        this.disableKey(key);
        return false;
    }

    protected abstract void newConnection(Multiplexer var1, SocketChannel var2) throws Exception;
}

