/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.ftp;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.dcache.ftp.BlockLog;
import org.dcache.ftp.DigestThread;
import org.dcache.pool.repository.RepositoryChannel;

public class DirectDigestThread
extends DigestThread {
    public static final int BLOCK_SIZE = 4096;

    public DirectDigestThread(RepositoryChannel channel, BlockLog log, MessageDigest digest) {
        super(channel, log, digest);
    }

    @Override
    public void run() {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            long position = 0L;
            this.advance(position + 4096L);
            long read = this._channel.read(buffer, position);
            while (read >= 0L) {
                buffer.flip();
                this._digest.update(buffer);
                buffer.clear();
                this.advance((position += read) + 4096L);
                read = this._channel.read(buffer, position);
            }
        }
        catch (Exception e) {
            this._error = e;
        }
    }
}

