/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.vehicles.IpProtocolInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetSocketAddress;

public class GFtpProtocolInfo
implements IpProtocolInfo {
    private String _name = "Unkown";
    private int _minor;
    private int _major;
    @Deprecated
    private String _host;
    @Deprecated
    private int _port;
    private InetSocketAddress _addr;
    private long _transferTime;
    private long _bytesTransferred;
    private String _mode = "S";
    private int _parallelStart = 5;
    private int _parallelMin = 5;
    private int _parallelMax = 5;
    private int _bufferSize;
    private long _offset;
    private long _size;
    private String _checksumType = "Unknown";
    private String _doorCellName;
    private String _doorCellDomainName;
    private String _clientAddress;
    private boolean _passive;
    private static final long serialVersionUID = 5591743387114320262L;

    public GFtpProtocolInfo(String protocol, int major, int minor, InetSocketAddress addr, int start, int min, int max, int bufferSize, long offset, long size) {
        this._name = protocol;
        this._minor = minor;
        this._major = major;
        this._addr = addr;
        this._host = addr.getHostString();
        this._port = addr.getPort();
        this._parallelStart = start;
        this._parallelMin = min;
        this._parallelMax = max;
        this._bufferSize = bufferSize;
        this._offset = offset;
        this._size = size;
    }

    public int getParallelStart() {
        return this._parallelStart;
    }

    public int getMin() {
        return this._parallelMin;
    }

    public int getMax() {
        return this._parallelMax;
    }

    public String getProtocol() {
        return this._name;
    }

    public int getMinorVersion() {
        return this._minor;
    }

    public int getMajorVersion() {
        return this._major;
    }

    public String getVersionString() {
        return this._name + "-" + this._major + "." + this._minor;
    }

    public void setBytesTransferred(long bytesTransferred) {
        this._bytesTransferred = bytesTransferred;
    }

    public void setTransferTime(long transferTime) {
        this._transferTime = transferTime;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public long getTransferTime() {
        return this._transferTime;
    }

    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    public String toString() {
        return this.getVersionString() + " " + this._addr.getAddress().getHostAddress() + " " + this._addr.getPort();
    }

    public void setMode(String mode) {
        this._mode = mode;
    }

    public String getMode() {
        return this._mode;
    }

    public long getOffset() {
        return this._offset;
    }

    public long getSize() {
        return this._size;
    }

    public String getDoorCellName() {
        return this._doorCellName;
    }

    public void setDoorCellName(String name) {
        this._doorCellName = name;
    }

    public String getDoorCellDomainName() {
        return this._doorCellDomainName;
    }

    public void setDoorCellDomainName(String name) {
        this._doorCellDomainName = name;
    }

    public String getClientAddress() {
        return this._clientAddress;
    }

    public void setClientAddress(String address) {
        this._clientAddress = address;
    }

    public boolean getPassive() {
        return this._passive;
    }

    public void setPassive(boolean passive) {
        this._passive = passive;
    }

    public void setChecksumType(String f) {
        this._checksumType = f;
    }

    public String getChecksumType() {
        return this._checksumType;
    }

    public InetSocketAddress getSocketAddress() {
        return this._addr;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._addr == null) {
            this._addr = new InetSocketAddress(this._host, this._port);
        }
    }
}

