/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.doors.EDataBlockNio;
import diskCacheV111.util.ProxyAdapter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Random;
import org.dcache.cells.AbstractCell;

public class SocketAdapter
implements Runnable,
ProxyAdapter {
    private final ServerSocketChannel _clientListenerChannel;
    private final ServerSocketChannel _poolListenerChannel;
    private int _dataChannelConnections;
    private boolean _modeE;
    private int _eodc = 1;
    private int _dataChannelsClosed;
    private int _eodSeen;
    private int _bufferSize;
    private boolean _clientToPool;
    private AbstractCell _door;
    private String _error;
    private Selector _selector;
    private int _maxBlockSize = 131072;
    private static Random _random = new Random();
    private Thread _thread;
    private boolean _closing;
    private final String _localAddress;

    public SocketAdapter(AbstractCell door, ServerSocketChannel clientListenerChannel) throws IOException {
        this._door = door;
        this._clientListenerChannel = clientListenerChannel;
        this._poolListenerChannel = ServerSocketChannel.open();
        this._poolListenerChannel.socket().bind(null);
        this._localAddress = this._clientListenerChannel.socket().getLocalSocketAddress().toString();
        this._clientToPool = true;
        this._modeE = false;
        this._eodSeen = 0;
        this._thread = new Thread((Runnable)this, "SocketAdapter-" + this._localAddress);
    }

    protected void info(String s) {
        this._door.info("Socket adapter " + this._localAddress + ": " + s);
    }

    protected void debug(String s) {
        this._door.debug("Socket adapter " + this._localAddress + ": " + s);
    }

    protected void warn(String s) {
        this._door.warn("Socket adapter " + this._localAddress + ": " + s);
    }

    protected void error(String s) {
        this._door.error("Socket adapter " + this._localAddress + ": " + s);
    }

    protected void fatal(String s) {
        this._door.fatal("Socket adapter " + this._localAddress + ": " + s);
    }

    protected void fatal(Throwable t) {
        this._door.fatal("Socket adapter " + this._localAddress + ": " + " caught unexpected exception: " + t.getMessage());
        this._door.fatal(t);
    }

    protected synchronized void addEODSeen() {
        ++this._eodSeen;
    }

    protected synchronized int getEODSeen() {
        return this._eodSeen;
    }

    protected synchronized int getEODExpected() {
        return this._eodc;
    }

    protected synchronized void setEODExpected(long count) {
        this.debug("Setting data channel count to " + count);
        this._selector.wakeup();
        this._eodc = (int)count;
    }

    protected synchronized void subtractDataChannel() {
        --this._dataChannelConnections;
        ++this._dataChannelsClosed;
        if (this._eodc < Integer.MAX_VALUE) {
            this.debug("Closing redirector " + this._dataChannelsClosed + ", remaining: " + this._dataChannelConnections + ", eodc says there will be: " + this.getEODExpected());
        } else {
            this.debug("Closing redirector " + this._dataChannelsClosed + ", remaining: " + this._dataChannelConnections);
        }
    }

    protected synchronized void addDataChannel() {
        ++this._dataChannelConnections;
    }

    protected synchronized int getDataChannelConnections() {
        return this._dataChannelConnections;
    }

    protected synchronized void setError(String msg) {
        if (!this.isClosing()) {
            this.error(msg);
            if (this._error == null) {
                this._thread.interrupt();
                this._error = msg;
            }
        }
    }

    protected synchronized void setFatalError(Exception e) {
        if (!this.isClosing()) {
            this.fatal(e);
            if (this._error == null) {
                this._thread.interrupt();
                this._error = e.getMessage();
            }
        }
    }

    @Override
    public synchronized String getError() {
        return this._error;
    }

    @Override
    public synchronized boolean hasError() {
        return this._error != null;
    }

    @Override
    public void setMaxBlockSize(int size) {
        this._maxBlockSize = size;
    }

    @Override
    public synchronized void setModeE(boolean modeE) {
        this._modeE = modeE;
        this._eodc = modeE ? Integer.MAX_VALUE : 1;
    }

    @Override
    public int getClientListenerPort() {
        return this._clientListenerChannel.socket().getLocalPort();
    }

    @Override
    public int getPoolListenerPort() {
        return this._poolListenerChannel.socket().getLocalPort();
    }

    @Override
    public void setDirClientToPool() {
        this._clientToPool = true;
    }

    @Override
    public void setDirPoolToClient() {
        this._clientToPool = false;
    }

    private synchronized void setClosing(boolean closing) {
        this._closing = closing;
    }

    private synchronized boolean isClosing() {
        return this._closing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block48: {
            assert (this._clientToPool || !this._modeE);
            ArrayList<Thread> redirectors = new ArrayList<Thread>();
            ArrayList<SocketChannel> sockets = new ArrayList<SocketChannel>();
            try {
                ServerSocketChannel outputSock;
                ServerSocketChannel inputSock;
                this._selector = Selector.open();
                if (this._clientToPool) {
                    inputSock = this._clientListenerChannel;
                    outputSock = this._poolListenerChannel;
                } else {
                    inputSock = this._poolListenerChannel;
                    outputSock = this._clientListenerChannel;
                }
                this.info("Accepting output connection on " + outputSock.socket().getLocalSocketAddress());
                SocketChannel output = outputSock.accept();
                sockets.add(output);
                if (this._bufferSize > 0) {
                    output.socket().setSendBufferSize(this._bufferSize);
                }
                output.socket().setKeepAlive(true);
                this.info("Opened " + output.socket());
                if (this._modeE) {
                    ByteBuffer block = ByteBuffer.allocate(17);
                    block.put((byte)64);
                    block.putLong(0L);
                    block.putLong(1L);
                    block.flip();
                    output.write(block);
                }
                this.info("Accepting input connection on " + inputSock.socket().getLocalSocketAddress());
                int totalStreams = 0;
                inputSock.configureBlocking(false);
                inputSock.register(this._selector, 16, null);
                while (!Thread.currentThread().isInterrupted() && totalStreams < this.getEODExpected()) {
                    this._selector.select();
                    for (SelectionKey key : this._selector.selectedKeys()) {
                        if (!key.isAcceptable()) continue;
                        SocketChannel input = inputSock.accept();
                        sockets.add(input);
                        this.info("Opened " + input.socket());
                        if (this._bufferSize > 0) {
                            input.socket().setSendBufferSize(this._bufferSize);
                        }
                        input.socket().setKeepAlive(true);
                        this.addDataChannel();
                        Thread redir = this._modeE ? new ModeERedirector(input, output) : new StreamRedirector(input, output);
                        redir.start();
                        redirectors.add(redir);
                        ++totalStreams;
                    }
                    this._selector.selectedKeys().clear();
                }
                this.debug("Waiting for all redirectors to finish");
                for (Thread redirector : redirectors) {
                    redirector.join();
                }
                redirectors.clear();
                this.debug("All redirectors have finished");
                if (!this._modeE) break block48;
                if (this.getEODExpected() == Integer.MAX_VALUE) {
                    this.setError("Did not receive EOF marker. Transfer failed.");
                } else if (this.getEODSeen() != this.getEODExpected()) {
                    this.setError("Did not see enough EOD markers. Transfer failed.");
                } else {
                    ByteBuffer block = ByteBuffer.allocate(17);
                    block.put((byte)8);
                    block.putLong(0L);
                    block.putLong(0L);
                    block.flip();
                    output.write(block);
                }
            }
            catch (InterruptedException e) {
                if (this._selector != null) {
                    try {
                        this._selector.close();
                        this._selector = null;
                    }
                    catch (IOException e2) {
                        this.setError(e2.getMessage());
                    }
                }
                for (Thread redirector : redirectors) {
                    redirector.interrupt();
                }
                for (SocketChannel channel : sockets) {
                    try {
                        channel.close();
                    }
                    catch (IOException e3) {
                        this.setError(e3.getMessage());
                    }
                }
            }
            catch (IOException e) {
                this.setError(e.getMessage());
            }
            catch (Exception e) {
                this.setFatalError(e);
            }
            finally {
                if (this._selector != null) {
                    try {
                        this._selector.close();
                        this._selector = null;
                    }
                    catch (IOException e) {
                        this.setError(e.getMessage());
                    }
                }
                for (Thread redirector : redirectors) {
                    redirector.interrupt();
                }
                for (SocketChannel channel : sockets) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        this.setError(e.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        this.info("Closing listener sockets");
        this.setClosing(true);
        this._thread.interrupt();
        try {
            this._poolListenerChannel.close();
        }
        catch (IOException e) {
            this.warn("Failed to close pool socket: " + e.getMessage());
        }
    }

    @Override
    public boolean isAlive() {
        return this._thread.isAlive();
    }

    @Override
    public void join() throws InterruptedException {
        this._thread.join();
    }

    @Override
    public void join(long millis) throws InterruptedException {
        this._thread.join(millis);
    }

    @Override
    public void start() {
        this._thread.start();
    }

    class ModeERedirector
    extends Thread {
        private SocketChannel _input;
        private SocketChannel _output;

        public ModeERedirector(SocketChannel input, SocketChannel output) {
            super("ModeE-Proxy-" + SocketAdapter.this._localAddress);
            this._input = input;
            this._output = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean eod = false;
            boolean used = false;
            ByteBuffer header = ByteBuffer.allocate(17);
            EDataBlockNio block = new EDataBlockNio(this.getName());
            String inputAddress = this._input.socket().getRemoteSocketAddress().toString();
            String outputAddress = this._output.socket().getRemoteSocketAddress().toString();
            boolean reading = true;
            try {
                SocketAdapter.this.info("Starting mode E proxy from " + inputAddress + " to " + outputAddress);
                block5: while (!eod && block.readHeader(this._input) > -1L) {
                    long count;
                    long position;
                    used = true;
                    if (block.isDescriptorSet(64)) {
                        SocketAdapter.this.setEODExpected(block.getDataChannelCount());
                        position = 0L;
                        count = 0L;
                    } else {
                        count = block.getSize();
                        position = block.getOffset();
                    }
                    while (count > 0L) {
                        long len = Math.min(count, (long)SocketAdapter.this._maxBlockSize);
                        if (block.readData(this._input, len) != len) break block5;
                        header.clear();
                        header.put((byte)0);
                        header.putLong(len);
                        header.putLong(position);
                        ByteBuffer[] buffers = new ByteBuffer[]{header, block.getData()};
                        buffers[0].flip();
                        buffers[1].flip();
                        reading = false;
                        this._output.write(buffers);
                        reading = true;
                        count -= len;
                        position += len;
                    }
                    if (!block.isDescriptorSet(8)) continue;
                    eod = true;
                }
                if (eod) {
                    SocketAdapter.this.addEODSeen();
                } else if (used) {
                    SocketAdapter.this.setError("Data channel from " + inputAddress + " was closed before EOD marker");
                }
                this._input.close();
            }
            catch (Exception e) {
                if (reading) {
                    SocketAdapter.this.setError("Error on socket to " + inputAddress + ": " + e.getMessage());
                } else {
                    SocketAdapter.this.setError("Error on socket to " + outputAddress + ": " + e.getMessage());
                }
            }
            finally {
                SocketAdapter.this.info("Redirector done, EOD = " + eod + ", used = " + used);
                SocketAdapter.this.subtractDataChannel();
            }
        }
    }

    class StreamRedirector
    extends Thread {
        private SocketChannel _input;
        private SocketChannel _output;

        public StreamRedirector(SocketChannel input, SocketChannel output) {
            super("ModeS-Proxy-" + SocketAdapter.this._localAddress);
            this._input = input;
            this._output = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String inputAddress = this._input.socket().getRemoteSocketAddress().toString();
            String outputAddress = this._output.socket().getRemoteSocketAddress().toString();
            boolean reading = true;
            try {
                SocketAdapter.this.info("Starting mode S proxy from " + inputAddress + " to " + outputAddress);
                ByteBuffer buffer = ByteBuffer.allocate(131072);
                while (this._input.read(buffer) != -1) {
                    buffer.flip();
                    reading = false;
                    this._output.write(buffer);
                    reading = true;
                    buffer.clear();
                }
                this._input.close();
            }
            catch (IOException e) {
                if (reading) {
                    SocketAdapter.this.setError("Error on socket to " + inputAddress + ": " + e.getMessage());
                } else {
                    SocketAdapter.this.setError("Error on socket to " + outputAddress + ": " + e.getMessage());
                }
            }
            finally {
                SocketAdapter.this.subtractDataChannel();
            }
        }
    }
}

