/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.movers;

public class GFtpPerfMarker {
    private static final String _cvsId = "$Id: GFtpPerfMarker.java,v 1.2 2005-10-26 17:56:41 aik Exp $";
    private long _timeStamp = System.currentTimeMillis();
    private long _stripeIndex;
    private long _stripeBytesTransferred;
    private long _totalStripeCount;

    public GFtpPerfMarker(long stripeIndex, long totalStripeCount) {
        this._stripeIndex = stripeIndex;
        this._totalStripeCount = totalStripeCount;
        this._stripeBytesTransferred = 0L;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public long getStripeIndex() {
        return this._stripeIndex;
    }

    public long getstripeBytesTransferred() {
        return this._stripeBytesTransferred;
    }

    public long getStripeCount() {
        return this._totalStripeCount;
    }

    public void setTimeStamp(long timeStamp) {
        this._timeStamp = timeStamp;
    }

    public void updateTimeStamp() {
        this._timeStamp = System.currentTimeMillis();
    }

    public void setStripeBytesTransferred(long byteCount) {
        this._stripeBytesTransferred = byteCount;
    }

    public void setBytesWithTime(long byteCount, long time) {
        this._stripeBytesTransferred = byteCount;
        this._timeStamp = time;
    }

    public void setBytesWithTime(long byteCount) {
        this._stripeBytesTransferred = byteCount;
        this._timeStamp = System.currentTimeMillis();
    }

    public void addBytesWithTime(long byteCountAdd) {
        this._stripeBytesTransferred += byteCountAdd;
        this._timeStamp = System.currentTimeMillis();
    }

    public String getReply() {
        long sec = this._timeStamp / 1000L;
        long hms = this._timeStamp % 1000L / 100L;
        String s = "112-Perf Marker\r\n Timestamp:  " + sec + "." + hms + "\r\n" + " Stripe Index: " + this._stripeIndex + "\r\n" + " Stripe Bytes Transferred: " + this._stripeBytesTransferred + "\r\n" + " Total Stripe Count: " + this._totalStripeCount + "\r\n" + "112 End.";
        return s;
    }

    public String toString() {
        long sec = this._timeStamp / 1000L;
        long hms = this._timeStamp % 1000L;
        String s = "GFtpPerfMarker: Timestamp=" + sec + "." + hms + "; StripeIndex=" + this._stripeIndex + "; StripeBytesTransferred=" + this._stripeBytesTransferred + "; TotalStripeCount=" + this._totalStripeCount + ";";
        return s;
    }
}

