/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import diskCacheV111.doors.FTPTransactionLog;
import diskCacheV111.doors.GssFtpDoorV1;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import dmg.util.Args;
import dmg.util.StreamEngine;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.Subjects;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosFtpDoorV1
extends GssFtpDoorV1 {
    private String _myPrincipalStr;
    private String[] _kdcList;

    public KerberosFtpDoorV1(String name, StreamEngine engine, Args args) {
        super(name, engine, args);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        Args args = this.getArgs();
        this._myPrincipalStr = args.getOpt("svc-principal");
        if (this._myPrincipalStr == null) {
            String problem = "KerberosFTPDoorV1: -svc-principal not specified";
            throw new IllegalArgumentException(problem);
        }
        this.info("KerberosFTPDoorV1: initializing kerberos ftp door service. Principal is '" + this._myPrincipalStr + "'");
        this._gssFlavor = "k5";
        String kdclist = args.getOpt("kdc-list");
        if (kdclist != null) {
            StringTokenizer tokens = new StringTokenizer(kdclist, ",");
            int n = tokens.countTokens();
            this._kdcList = new String[n];
            for (int i = 0; i < n; ++i) {
                this._kdcList[i] = tokens.nextToken();
                this.info("KerberosFTPDoorV1: kdc[" + i + "] = " + this._kdcList[i]);
            }
        }
        this.ftpDoorName = "Kerberos FTP";
    }

    @Override
    public void startTlog(FTPTransactionLog tlog, String path, String action) {
        if (this._subject != null) {
            try {
                String user = Subjects.getUserName((Subject)this._subject) + "(" + Subjects.getUid((Subject)this._subject) + "." + Subjects.getPrimaryGid((Subject)this._subject) + ")";
                tlog.begin(user, "krbftp", action, path, this._engine.getInetAddress());
            }
            catch (Exception e) {
                this.error("KerberosFTPDoorV1::startTlog: couldn't start tLog. Ignoring exception: " + e.getMessage());
            }
        }
    }

    @Override
    protected GSSContext getServiceContext() throws GSSException {
        Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
        Oid krb5PrincipalNameType = new Oid("1.2.840.113554.1.2.2.1");
        int nretry = 10;
        GSSException error = null;
        Properties sysp = System.getProperties();
        GSSCredential MyCredential = null;
        GSSManager _GManager = GSSManager.getInstance();
        this.debug("KerberosFTPDoorV1::getServiceContext: calling _GManager.createName(\"" + this._myPrincipalStr + "\", null)");
        GSSName MyPrincipal = _GManager.createName(this._myPrincipalStr, null);
        this.info("KerberosFTPDoorV1::getServiceContext: principal=\"" + MyPrincipal + "\"");
        while (MyCredential == null && nretry-- > 0) {
            if (this._kdcList != null && this._kdcList.length > 0) {
                String kdc = this._kdcList[nretry % this._kdcList.length];
                sysp.put("java.security.krb5.kdc", kdc);
            }
            try {
                MyCredential = _GManager.createCredential(MyPrincipal, 0, krb5Mechanism, 2);
            }
            catch (GSSException e) {
                this.debug("KerberosFTPDoorV1::getServiceContext: got exception  while looking up credential: " + e.getMessage());
                error = e;
            }
        }
        if (MyCredential == null) {
            throw error;
        }
        this.info("KerberosFTPDoorV1::getServiceContext: credential=\"" + MyCredential + "\"");
        GSSContext context = _GManager.createContext(MyCredential);
        try {
            ChannelBinding cb = new ChannelBinding(this._engine.getInetAddress(), InetAddress.getLocalHost(), null);
            context.setChannelBinding(cb);
        }
        catch (UnknownHostException e) {
            String errmsg = "KerberosFTPDoorV1::getServiceContext: can't bind channel to localhost:" + e.getMessage();
            this.error(errmsg);
            throw new GSSException(13, 0, errmsg);
        }
        return context;
    }

    @Override
    public void ac_user(String arg) {
        if (arg.equals("")) {
            this.reply(this.err("USER", arg));
            return;
        }
        if (this._serviceContext == null || !this._serviceContext.isEstablished()) {
            this.reply("530 Authentication required");
            return;
        }
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new LoginNamePrincipal(arg));
        subject.getPrincipals().add(new KerberosPrincipal(this._gssIdentity.toString()));
        subject.getPrincipals().add((Principal)this._origin);
        try {
            this.login(subject);
            this.reply("200 User " + arg + " logged in");
        }
        catch (PermissionDeniedCacheException e) {
            this.warn("Login denied for " + subject);
            this.println("530 Login incorrect");
        }
        catch (CacheException e) {
            this.error("Login failed for " + subject + ": " + (Object)((Object)e));
            this.println("530 Login failed: " + e.getMessage());
        }
    }
}

