/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import diskCacheV111.doors.FTPTransactionLog;
import diskCacheV111.doors.GssFtpDoorV1;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import dmg.util.Args;
import dmg.util.StreamEngine;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.Subjects;
import org.dcache.cells.Option;
import org.dcache.util.Crypto;
import org.globus.gsi.CredentialException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.X509Credential;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class GsiFtpDoorV1
extends GssFtpDoorV1 {
    @Option(name="service-key", required=true)
    protected String service_key;
    @Option(name="service-cert", required=true)
    protected String service_cert;
    @Option(name="service-trusted-certs", required=true)
    protected String service_trusted_certs;
    @Option(name="gridftp.security.ciphers", required=true)
    protected String cipherFlags;
    private String _user;

    public GsiFtpDoorV1(String name, StreamEngine engine, Args args) {
        super(name, engine, args);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this._gssFlavor = "gsi";
        this.ftpDoorName = "GSI FTP";
    }

    @Override
    public void startTlog(FTPTransactionLog tlog, String path, String action) {
        if (this._subject != null) {
            try {
                String user = this._user + "(" + Subjects.getUid((Subject)this._subject) + "." + Subjects.getPrimaryGid((Subject)this._subject) + ")";
                tlog.begin(user, "gsiftp", action, path, this._engine.getInetAddress());
            }
            catch (Exception e) {
                this.error("GsiFtpDoor: couldn't start tLog. Ignoring exception: " + e.getMessage());
            }
        }
    }

    @Override
    protected GSSContext getServiceContext() throws GSSException {
        X509Credential serviceCredential;
        try {
            serviceCredential = new X509Credential(this.service_cert, this.service_key);
        }
        catch (CredentialException gce) {
            String errmsg = "GsiFtpDoor: couldn't load host globus credentials: " + gce.toString();
            this.error(errmsg);
            throw new GSSException(13, 0, errmsg);
        }
        catch (IOException ioe) {
            throw new GSSException(13, 0, "could not load host globus credentials " + ioe.toString());
        }
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(serviceCredential, 2);
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext((GSSCredential)cred);
        context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
        context.setBannedCiphers(Crypto.getBannedCipherSuitesFromConfigurationValue((String)this.cipherFlags));
        return context;
    }

    @Override
    public void ac_user(String arg) {
        if (arg.equals("")) {
            this.reply(this.err("USER", arg));
            return;
        }
        if (this._serviceContext == null || !this._serviceContext.isEstablished()) {
            this.reply("530 Authentication required");
            return;
        }
        Subject subject = new Subject();
        try {
            subject.getPrincipals().add((Principal)this._origin);
            if (!arg.equals(":globus-mapping:")) {
                subject.getPrincipals().add((Principal)new LoginNamePrincipal(arg));
            }
            if (!(this._serviceContext instanceof ExtendedGSSContext)) {
                throw new RuntimeException("GSSContext not instance of ExtendedGSSContext");
            }
            ExtendedGSSContext extendedcontext = (ExtendedGSSContext)this._serviceContext;
            X509Certificate[] chain = (X509Certificate[])extendedcontext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
            subject.getPublicCredentials().add(chain);
            this.login(subject);
            this._user = arg;
            this.reply("200 User " + arg + " logged in");
        }
        catch (GSSException e) {
            this.error("Failed to extract X509 chain: " + e);
            this.println("530 Login failed: " + e.getMessage());
        }
        catch (PermissionDeniedCacheException e) {
            this.warn("Login denied for " + subject + ": " + (Object)((Object)e));
            this.println("530 Login incorrect");
        }
        catch (CacheException e) {
            this.error("Login failed for " + subject + ": " + (Object)((Object)e));
            this.println("530 Login failed: " + e.getMessage());
        }
    }
}

