/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class EDataBlockNio {
    private ByteBuffer header;
    private ByteBuffer data;
    private String _myName = "unknown";
    public static final int EOR_DESCRIPTOR = 128;
    public static final int EOF_DESCRIPTOR = 64;
    public static final int SUSPECTED_ERROR_DESCRIPTOR = 32;
    public static final int RESTART_MARKER_DESCRIPTOR = 16;
    public static final int EOD_DESCRIPTOR = 8;
    public static final int SENDER_CLOSES_THIS_STREAM_DESCRIPTOR = 4;
    public static final int HEADER_LENGTH = 17;

    public EDataBlockNio(String name) {
        this._myName = name;
    }

    public EDataBlockNio() {
    }

    public ByteBuffer getHeader() {
        return this.header;
    }

    public byte getDescriptors() {
        return this.header.get(0);
    }

    public boolean isDescriptorSet(int descriptor) {
        return (this.getDescriptors() & descriptor) != 0;
    }

    public void setDCCountTo1() {
        for (int i = 9; i < 17; ++i) {
            this.header.put(i, (byte)0);
        }
        this.header.put(16, (byte)1);
    }

    public void setDescriptor(int descriptor) {
        this.header.put(0, (byte)(this.getDescriptors() | descriptor));
    }

    public void unsetDescriptor(int descriptor) {
        this.header.put(0, (byte)(this.getDescriptors() & ~descriptor));
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public long getSize() {
        return this.header.getLong(1);
    }

    public long getDataChannelCount() {
        if (this.isDescriptorSet(64)) {
            return this.getOffset();
        }
        return -1L;
    }

    public long getOffset() {
        return this.header.getLong(9);
    }

    public long readHeader(SocketChannel socketChannel) {
        int len;
        int n;
        if (this.header == null) {
            this.header = ByteBuffer.allocate(17);
        }
        this.header.clear();
        this.header.position(0);
        for (len = 0; len < 17; len += n) {
            try {
                n = socketChannel.read(this.header);
            }
            catch (Exception e) {
                break;
            }
            if (n <= 0) break;
        }
        if (len < 17) {
            return -1L;
        }
        return len;
    }

    public long readData(SocketChannel socketChannel, long size) {
        if (this.data == null || this.data.capacity() < (int)size) {
            this.data = ByteBuffer.allocate((int)size);
        }
        this.data.clear();
        this.data.position(0);
        this.data.limit((int)size);
        int n = 0;
        while ((long)n < size) {
            int nr;
            try {
                nr = socketChannel.read(this.data);
            }
            catch (Exception e) {
                break;
            }
            if (nr <= 0) break;
            n += nr;
        }
        if ((long)n < size) {
            n = -1;
        }
        return n;
    }

    public long read(SocketChannel socketChannel) {
        if (this.readHeader(socketChannel) == -1L) {
            return -1L;
        }
        return this.readData(socketChannel, this.getSize());
    }
}

