/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import java.io.InputStream;

public class EDataBlock {
    private byte[] header;
    private byte[] data;
    private String _myName = "unknown";
    public static final int EOR_DESCRIPTOR = 128;
    public static final int EOF_DESCRIPTOR = 64;
    public static final int SUSPECTED_ERROR_DESCRIPTOR = 32;
    public static final int RESTART_MARKER_DESCRIPTOR = 16;
    public static final int EOD_DESCRIPTOR = 8;
    public static final int SENDER_CLOSES_THIS_STREAM_DESCRIPTOR = 4;
    public static final int HEADER_LENGTH = 17;

    public EDataBlock(String name) {
        this._myName = name;
    }

    public EDataBlock() {
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte getDescriptors() {
        return this.header[0];
    }

    public boolean isDescriptorSet(int descriptor) {
        return (this.header[0] & descriptor) != 0;
    }

    public void setDCCountTo1() {
        for (int i = 9; i < 17; ++i) {
            this.header[i] = 0;
        }
        this.header[16] = 1;
    }

    public void setDescriptor(int descriptor) {
        this.header[0] = (byte)(this.header[0] | descriptor);
    }

    public void unsetDescriptor(int descriptor) {
        this.header[0] = (byte)(this.header[0] & ~descriptor);
    }

    public byte[] getData() {
        return this.data;
    }

    public long getSize() {
        long size = 0L;
        for (int i = 1; i < 9; ++i) {
            size = size << 8 | (long)(this.header[i] & 0xFF);
        }
        return size;
    }

    public long getDataChannelCount() {
        if (this.isDescriptorSet(64)) {
            return this.getOffset();
        }
        return -1L;
    }

    public long getOffset() {
        long offset = 0L;
        for (int i = 9; i < 17; ++i) {
            offset = offset << 8 | (long)(this.header[i] & 0xFF);
        }
        return offset;
    }

    public long read(InputStream str) {
        int len;
        int n;
        this.header = new byte[17];
        for (len = 0; len < 17; len += n) {
            try {
                n = str.read(this.header, len, 17 - len);
            }
            catch (Exception e) {
                break;
            }
            if (n <= 0) break;
        }
        if (len < 17) {
            return -1L;
        }
        long size = 0L;
        for (int i = 1; i < 9; ++i) {
            size = size << 8 | (long)(this.header[i] & 0xFF);
        }
        this.data = new byte[(int)size];
        int n2 = 0;
        while ((long)n2 < size) {
            int nr;
            try {
                nr = str.read(this.data, n2, (int)size - n2);
            }
            catch (Exception e) {
                break;
            }
            if (nr <= 0) break;
            n2 += nr;
        }
        if ((long)n2 < this.getSize()) {
            n2 = -1;
        }
        return n2;
    }

    public String toString() {
        return "EDataBlock(" + this._myName + "), size=" + this.getSize() + " , offset=" + this.getOffset();
    }
}

