/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.InvalidHandlerConfigurationException;
import org.dcache.xrootd.plugins.authn.gsi.GSIAuthenticationHandler;
import org.globus.gsi.CertificateRevocationLists;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.proxy.ProxyPathValidator;
import org.globus.gsi.proxy.ProxyPathValidatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSIAuthenticationFactory
implements AuthenticationFactory {
    private static final Logger _logger = LoggerFactory.getLogger(GSIAuthenticationFactory.class);
    private String _hostCertificatePath;
    private String _hostKeyPath;
    private String _caCertificatePath;
    private X509Certificate _hostCertificate;
    private PrivateKey _hostKey;
    private TrustedCertificates _trustedCerts;
    private long _hostCertRefreshInterval;
    private long _trustAnchorRefreshInterval;
    private long _hostCertRefreshTimestamp = 0L;
    private long _trustAnchorRefreshTimestamp = 0L;
    private ProxyPathValidator _proxyValidator = new ProxyPathValidator();
    private boolean _verifyHostCertificate;

    public GSIAuthenticationFactory(Properties properties) {
        this._hostKeyPath = properties.getProperty("xrootd.gsi.hostcert.key");
        this._hostCertificatePath = properties.getProperty("xrootd.gsi.hostcert.cert");
        this._hostCertRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.hostcert.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.hostcert.refresh")));
        this._verifyHostCertificate = Boolean.parseBoolean(properties.getProperty("xrootd.gsi.hostcert.verify"));
        this._caCertificatePath = properties.getProperty("xrootd.gsi.ca.path");
        this._trustAnchorRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.ca.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.ca.refresh")));
    }

    public AuthenticationHandler createHandler() throws InvalidHandlerConfigurationException {
        CertificateRevocationLists crls = CertificateRevocationLists.getDefaultCertificateRevocationLists();
        try {
            this.loadTrustAnchors();
            this.loadServerCredentials(crls);
        }
        catch (ProxyPathValidatorException ppvex) {
            String msg = "Could not verify server certificate chain";
            throw new InvalidHandlerConfigurationException(msg, (Throwable)ppvex);
        }
        catch (GeneralSecurityException gssex) {
            String msg = "Could not load certificates/key due to security error";
            throw new InvalidHandlerConfigurationException(msg, (Throwable)gssex);
        }
        catch (IOException ioex) {
            String msg = "Could not read certificates/key from file-system";
            throw new InvalidHandlerConfigurationException(msg, (Throwable)ioex);
        }
        return new GSIAuthenticationHandler(this._hostCertificate, this._hostKey, this._trustedCerts, crls);
    }

    private synchronized void loadTrustAnchors() {
        long timeSinceLastTrustAnchorRefresh = System.currentTimeMillis() - this._trustAnchorRefreshTimestamp;
        if (this._trustedCerts == null || timeSinceLastTrustAnchorRefresh >= this._trustAnchorRefreshInterval) {
            _logger.info("CA certificate directory: {}", (Object)this._caCertificatePath);
            this._trustedCerts = TrustedCertificates.load((String)this._caCertificatePath);
            this._trustAnchorRefreshTimestamp = System.currentTimeMillis();
        }
    }

    private synchronized void loadServerCredentials(CertificateRevocationLists crls) throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, ProxyPathValidatorException, NoSuchProviderException {
        long timeSinceLastServerRefresh = System.currentTimeMillis() - this._hostCertRefreshTimestamp;
        if (this._hostCertificate == null || this._hostKey == null || timeSinceLastServerRefresh >= this._hostCertRefreshInterval) {
            _logger.info("Time since last server cert refresh {}", (Object)timeSinceLastServerRefresh);
            _logger.info("Loading server certificates. Current refresh interval: {} ms", (Object)this._hostCertRefreshInterval);
            this.loadHostCertificate();
            this.loadHostKey();
            if (this._verifyHostCertificate) {
                _logger.info("Verifying host certificate");
                this.verifyHostCertificate(crls);
            }
            this._hostCertRefreshTimestamp = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHostCertificate() throws CertificateException, IOException, NoSuchProviderException {
        FileInputStream fis = new FileInputStream(this._hostCertificatePath);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            this._hostCertificate = (X509Certificate)cf.generateCertificate(fis);
        }
        finally {
            ((InputStream)fis).close();
        }
    }

    private void loadHostKey() throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        BufferedReader br = new BufferedReader(new FileReader(this._hostKeyPath));
        KeyPair kp = (KeyPair)new PEMReader((Reader)br).readObject();
        this._hostKey = kp.getPrivate();
    }

    private void verifyHostCertificate(CertificateRevocationLists crls) throws ProxyPathValidatorException {
        this._proxyValidator.validate(new X509Certificate[]{this._hostCertificate}, this._trustedCerts.getCertificates(), crls, this._trustedCerts.getSigningPolicies());
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

