/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.security.Principal;
import java.util.Properties;
import java.util.Set;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.GroupNamePrincipal;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.NoSuchPrincipalException;
import org.dcache.gplazma.plugins.GPlazmaIdentityPlugin;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.plugins.GPlazmaSessionPlugin;

public class Nsswitch
implements GPlazmaMappingPlugin,
GPlazmaIdentityPlugin,
GPlazmaSessionPlugin {
    private final LibC _libc = (LibC)Native.loadLibrary((String)"c", LibC.class);

    public Nsswitch(Properties properties) throws UnsatisfiedLinkError {
    }

    private __password findPasswordRecord(Set<Principal> principals) {
        for (UserNamePrincipal principal : Iterables.filter(principals, UserNamePrincipal.class)) {
            __password p = this._libc.getpwnam(principal.getName());
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public void map(Set<Principal> principals) throws AuthenticationException {
        __password p = this.findPasswordRecord(principals);
        if (p != null) {
            int[] gids;
            principals.add((Principal)new UidPrincipal((long)p.uid));
            principals.add((Principal)new GidPrincipal((long)p.gid, true));
            for (int id : gids = this.groupsOf(p)) {
                principals.add((Principal)new GidPrincipal((long)id, false));
            }
        } else {
            throw new AuthenticationException("no mapping");
        }
    }

    public Principal map(Principal principal) throws NoSuchPrincipalException {
        __group g;
        if (principal instanceof UserNamePrincipal) {
            __password p = this._libc.getpwnam(principal.getName());
            if (p != null) {
                return new UidPrincipal((long)p.uid);
            }
        } else if (principal instanceof GroupNamePrincipal && (g = this._libc.getgrnam(principal.getName())) != null) {
            return new GidPrincipal((long)g.gid, false);
        }
        throw new NoSuchPrincipalException(principal);
    }

    public Set<Principal> reverseMap(Principal principal) throws NoSuchPrincipalException {
        __group g;
        if (principal instanceof UidPrincipal) {
            __password p = this._libc.getpwuid((int)((UidPrincipal)principal).getUid());
            if (p != null) {
                return Sets.newHashSet((Object[])new Principal[]{new UserNamePrincipal(p.name)});
            }
        } else if (principal instanceof GidPrincipal && (g = this._libc.getgrgid((int)((GidPrincipal)principal).getGid())) != null) {
            return Sets.newHashSet((Object[])new Principal[]{new GroupNamePrincipal(g.name)});
        }
        throw new NoSuchPrincipalException(principal);
    }

    public void session(Set<Principal> authorizedPrincipals, Set<Object> attrib) throws AuthenticationException {
        attrib.add(new HomeDirectory("/"));
        attrib.add(new RootDirectory("/"));
        attrib.add(new ReadOnly(false));
    }

    private int[] groupsOf(__password pwrecord) {
        boolean done = false;
        int[] groups = new int[]{};
        while (!done) {
            IntByReference ngroups = new IntByReference();
            ngroups.setValue(groups.length);
            if (this._libc.getgrouplist(pwrecord.name, pwrecord.gid, groups, ngroups) < 0) {
                groups = new int[ngroups.getValue()];
                continue;
            }
            done = true;
        }
        return groups;
    }

    public static interface LibC
    extends Library {
        public __password getpwnam(String var1);

        public __password getpwuid(int var1);

        public __group getgrnam(String var1);

        public __group getgrgid(int var1);

        public int getgrouplist(String var1, int var2, int[] var3, IntByReference var4);
    }

    public static class __group
    extends Structure {
        public String name;
        public String passwd;
        public int gid;
        public Pointer mem;
    }

    public static class __password
    extends Structure {
        public String name;
        public String passwd;
        public int uid;
        public int gid;
        public String gecos;
        public String dir;
        public String shell;
    }
}

