/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.dcache.auth.PasswordCredential;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.util.Preconditions;

public class JaasPlugin
implements GPlazmaAuthenticationPlugin {
    private static final String NAME = "gplazma.jaas.name";
    private final String _name;

    public JaasPlugin(Properties properties) {
        String name = properties.getProperty(NAME);
        com.google.common.base.Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.jaas.name");
        this._name = name;
    }

    public void authenticate(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> identifiedPrincipals) throws AuthenticationException {
        PasswordCredential password = (PasswordCredential)Iterables.getFirst((Iterable)Iterables.filter(privateCredentials, PasswordCredential.class), null);
        Preconditions.checkAuthentication((password != null ? 1 : 0) != 0, (String)"no login name");
        try {
            LoginContext loginContext = new LoginContext(this._name, new PasswordCallbackHandler(password));
            loginContext.login();
            identifiedPrincipals.addAll(loginContext.getSubject().getPrincipals());
            JaasPlugin.tryToLogout(loginContext);
        }
        catch (LoginException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private static void tryToLogout(LoginContext loginContext) {
        if (loginContext == null) {
            return;
        }
        try {
            loginContext.logout();
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    private static class PasswordCallbackHandler
    implements CallbackHandler {
        private final String _userName;
        private final char[] _password;

        public PasswordCallbackHandler(PasswordCredential credential) {
            this._userName = credential.getUsername();
            this._password = credential.getPassword().toCharArray();
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this._userName);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this._password);
                    continue;
                }
                if (callback instanceof TextOutputCallback) continue;
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
        }
    }
}

