/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.engine.local.Entity;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEntity
extends Entity {
    private final File file;

    public FileEntity(File file, MetadataService metadataService) {
        super(metadataService);
        this.file = file;
    }

    @Override
    public boolean exists() {
        return this.getFile().exists();
    }

    @Override
    public List<Entity> getChildren() {
        ArrayList<FileEntity> result = null;
        if (this.isDirectory()) {
            result = new ArrayList<FileEntity>();
            for (File f : this.getFile().listFiles()) {
                result.add(new FileEntity(f, this.getMetadataService()));
            }
        }
        return result;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.getFile().getName();
    }

    @Override
    public Entity getParent() {
        File parentFile = this.getFile().getParentFile();
        return parentFile == null ? null : new FileEntity(parentFile, this.getMetadataService());
    }

    @Override
    public Representation getRepresentation(MediaType defaultMediaType, int timeToLive) {
        return new FileRepresentation(this.getFile(), defaultMediaType, timeToLive);
    }

    @Override
    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    @Override
    public boolean isNormal() {
        return this.getFile().isFile();
    }
}

