/*
 * Decompiled with CFR 0.152.
 */
package io.milton.simpleton;

import io.milton.http.HttpManager;
import io.milton.simpleton.SimpleMiltonRequest;
import io.milton.simpleton.SimpleMiltonResponse;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    long enqueueTime = System.currentTimeMillis();
    long startTime;
    final HttpManager httpManager;
    final Response response;
    final Request request;
    Thread thisThread;
    private SimpleMiltonRequest miltonRequest;
    private SimpleMiltonResponse miltonResponse;

    public Task(HttpManager httpManager, Request request, Response response) {
        this.httpManager = httpManager;
        this.response = response;
        this.request = request;
    }

    @Override
    public void run() {
        this.thisThread = Thread.currentThread();
        this.startTime = System.currentTimeMillis();
        try {
            this.httpManager.process(this.getMiltonRequest(), this.getMiltonResponse());
            this.miltonResponse.close();
        }
        catch (Exception e) {
            log.error("exception processing request: " + this.request.getTarget(), (Throwable)e);
            try {
                this.respondFinalError(this);
            }
            catch (Exception e2) {
                log.error("exception was thrown in processing, and again an exception was thrown generating error content", (Throwable)e2);
            }
        }
    }

    private void respondFinalError(Task t) {
        try {
            log.warn("setting error status becaue request could not be processed");
            t.response.setCode(500);
            t.response.close();
        }
        catch (Exception e) {
            log.error("error setting last chance error status", (Throwable)e);
        }
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        return this.request.getMethod() + " " + this.request.getAddress().toString();
    }

    public SimpleMiltonRequest getMiltonRequest() {
        if (this.miltonRequest == null) {
            this.miltonRequest = new SimpleMiltonRequest(this.getRequest());
        }
        return this.miltonRequest;
    }

    public SimpleMiltonResponse getMiltonResponse() {
        if (this.miltonResponse == null) {
            this.miltonResponse = new SimpleMiltonResponse(this.getResponse());
        }
        return this.miltonResponse;
    }
}

