/*
 * Decompiled with CFR 0.152.
 */
package io.milton.simpleton;

import io.milton.common.FileUtils;
import io.milton.common.ReadingException;
import io.milton.common.StreamUtils;
import io.milton.common.WritingException;
import io.milton.http.FileItem;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.simpleframework.http.Part;

public class SimpleFileItem
implements FileItem {
    public final String name;
    public final String contentType;
    public final String fileName;
    private long size;
    private File f;
    private FileOutputStream out;

    public SimpleFileItem(String name, String contentType, String fileName) {
        try {
            this.name = name;
            this.contentType = contentType;
            this.fileName = fileName;
            this.f = File.createTempFile("upload", name);
            this.out = new FileOutputStream(this.f);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFieldName() {
        return this.name;
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.f);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getName() {
        return this.fileName;
    }

    public long getSize() {
        return this.f.length();
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void addPart(Part part) {
        try {
            StreamUtils.readTo((InputStream)part.getInputStream(), (OutputStream)this.out);
        }
        catch (ReadingException ex) {
            throw new RuntimeException(ex);
        }
        catch (WritingException ex) {
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void finishedReadingRequest() {
        FileUtils.close((Closeable)this.out);
    }
}

