/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.common.ContentTypeUtils;
import io.milton.common.Path;
import io.milton.http.HttpManager;
import io.milton.http.ResourceFactory;
import io.milton.resource.Resource;
import io.milton.servlet.Config;
import io.milton.servlet.Initable;
import io.milton.servlet.MiltonUtils;
import io.milton.servlet.StaticResource;
import io.milton.servlet.UrlResource;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceFactory
implements ResourceFactory,
Initable {
    private static final Logger log = LoggerFactory.getLogger(WebResourceFactory.class);
    private Config config;
    private String basePath = "WEB-INF/static";
    private Date modDate = new Date();

    public WebResourceFactory() {
    }

    public WebResourceFactory(Config config) {
        this.config = config;
    }

    @Override
    public void init(Config config, HttpManager manager) {
        this.config = config;
    }

    public Resource getResource(String host, String url) {
        Path p = Path.path((String)url);
        String contentType = this.config != null ? MiltonUtils.getContentType(this.config.getServletContext(), p.getName()) : ContentTypeUtils.findContentTypes((String)p.getName());
        String path = this.stripContext(url);
        path = this.basePath + path;
        path = path.trim();
        String realPath = this.config.getServletContext().getRealPath(path);
        File file = realPath != null ? new File(path) : null;
        if (file == null || !file.exists()) {
            URL resource;
            try {
                resource = this.config.getServletContext().getResource(path);
            }
            catch (MalformedURLException ex) {
                log.warn("malformed url when attempting to locate servlet resource", (Object)path);
                return null;
            }
            if (resource != null) {
                return new UrlResource(p.getName(), resource, contentType, this.modDate);
            }
            return null;
        }
        return new StaticResource(file, url, contentType);
    }

    @Override
    public void destroy(HttpManager manager) {
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private String stripContext(String url) {
        String contextName = this.config.getServletContext().getServletContextName();
        if (contextName == null || contextName.equals("") || this.config.getServletContext().getServletContextName().equals("/")) {
            return url;
        }
        String contextPath = "/" + contextName;
        url = url.replaceFirst('/' + contextPath, "");
        return url;
    }
}

