/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.common.ContentTypeUtils;
import io.milton.common.Path;
import io.milton.http.ResourceFactory;
import io.milton.resource.Resource;
import io.milton.servlet.StaticResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(StaticResourceFactory.class);
    public static final String FILE_ROOTS_SYS_PROP_NAME = "static.resource.roots";
    private final List<File> roots;
    private String contextPath;
    private Date modDate = new Date();

    public StaticResourceFactory() {
        this.roots = new ArrayList<File>();
        String sRoots = System.getProperty(FILE_ROOTS_SYS_PROP_NAME);
        if (sRoots != null && sRoots.length() > 0) {
            for (String s : sRoots.split(",")) {
                if ((s = s.trim()).length() <= 0) continue;
                File root = new File(s);
                if (root.exists()) {
                    if (root.isDirectory()) {
                        this.roots.add(root);
                        continue;
                    }
                    throw new RuntimeException("Extra file root is not a directory: " + root.getAbsolutePath());
                }
                throw new RuntimeException("Extra file root does not exist: " + root.getAbsolutePath());
            }
        }
    }

    public StaticResourceFactory(File root) {
        this();
        this.roots.add(root);
    }

    public StaticResourceFactory(List<File> roots) {
        this();
        this.roots.addAll(roots);
    }

    public Resource getResource(String host, String url) {
        Path p = Path.path((String)url);
        String contentType = ContentTypeUtils.findContentTypes((String)p.getName());
        String s = this.stripContext(url);
        for (File root : this.roots) {
            File file = new File(root, s);
            if (!file.exists() || !file.isFile()) continue;
            return new StaticResource(file, url, contentType);
        }
        return null;
    }

    private String stripContext(String url) {
        if (this.contextPath != null && this.contextPath.length() > 0) {
            url = url.replaceFirst('/' + this.contextPath, "");
            log.debug("stripped context: " + url);
            return url;
        }
        return url;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Date getModDate() {
        return this.modDate;
    }

    public void setModDate(Date modDate) {
        this.modDate = modDate;
    }

    public List<File> getRoots() {
        return this.roots;
    }
}

