/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.common.ContentTypeUtils;
import io.milton.http.Auth;
import io.milton.http.LockToken;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;

public class StaticResource
implements GetableResource {
    private final File file;
    private String contentType;

    public StaticResource(File file, String url, String contentType) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Static resource must be a file, this is a directory: " + file.getAbsolutePath());
        }
        this.file = file;
        this.contentType = contentType;
    }

    public String getUniqueId() {
        return this.file.getName() + "_ " + this.file.lastModified();
    }

    public int compareTo(Resource res) {
        return this.getName().compareTo(res.getName());
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException {
        FileInputStream fis = new FileInputStream(this.file);
        BufferedInputStream bin = new BufferedInputStream(fis);
        byte[] buffer = new byte[1024];
        int n = 0;
        while (-1 != (n = bin.read(buffer))) {
            out.write(buffer, 0, n);
        }
    }

    public String getName() {
        return this.file.getName();
    }

    public Object authenticate(String user, String password) {
        return "ok";
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String getRealm() {
        return "milton.io";
    }

    public Date getModifiedDate() {
        Date dt = new Date(this.file.lastModified());
        return dt;
    }

    public Long getContentLength() {
        return this.file.length();
    }

    public String getContentType(String preferredList) {
        String mime = ContentTypeUtils.findContentTypes((String)this.getName());
        String s = ContentTypeUtils.findAcceptableContentType((String)mime, (String)preferredList);
        return s;
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Long getMaxAgeSeconds(Auth auth) {
        Long ll = 315360000L;
        return ll;
    }

    public LockToken getLockToken() {
        return null;
    }
}

