/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.config.HttpManagerBuilder;
import io.milton.http.HttpManager;
import io.milton.mail.MailServer;
import io.milton.mail.MailServerBuilder;
import io.milton.servlet.FilterConfigWrapper;
import io.milton.servlet.MiltonServlet;
import io.milton.servlet.ServletRequest;
import io.milton.servlet.ServletResponse;
import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class SpringMiltonFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SpringMiltonFilter.class);
    private ClassPathXmlApplicationContext context;
    private HttpManager httpManager;
    private MailServer mailServer;
    private FilterConfig filterConfig;
    private ServletContext servletContext;
    private String[] excludeMiltonPaths;

    public void init(FilterConfig fc) throws ServletException {
        StaticApplicationContext parent = new StaticApplicationContext();
        FilterConfigWrapper configWrapper = new FilterConfigWrapper(fc);
        parent.getBeanFactory().registerSingleton("config", (Object)configWrapper);
        parent.getBeanFactory().registerSingleton("servletContext", (Object)fc.getServletContext());
        File webRoot = new File(fc.getServletContext().getRealPath("/"));
        parent.getBeanFactory().registerSingleton("webRoot", (Object)webRoot);
        log.info("Registered root webapp path in: webroot=" + webRoot.getAbsolutePath());
        parent.refresh();
        this.context = new ClassPathXmlApplicationContext(new String[]{"applicationContext.xml"}, (ApplicationContext)parent);
        Object milton = this.context.getBean("milton.http.manager");
        if (milton instanceof HttpManager) {
            this.httpManager = (HttpManager)milton;
        } else if (milton instanceof HttpManagerBuilder) {
            HttpManagerBuilder builder = (HttpManagerBuilder)milton;
            this.httpManager = builder.buildHttpManager();
        }
        this.filterConfig = fc;
        this.servletContext = fc.getServletContext();
        System.out.println("servletContext: " + this.servletContext.getClass());
        String sExcludePaths = fc.getInitParameter("milton.exclude.paths");
        log.info("init: exclude paths: " + sExcludePaths);
        this.excludeMiltonPaths = sExcludePaths.split(",");
        if (this.context.containsBean("milton.mail.server")) {
            log.info("init mailserver...");
            Object oMailServer = this.context.getBean("milton.mail.server");
            if (oMailServer instanceof MailServer) {
                this.mailServer = (MailServer)oMailServer;
            } else if (oMailServer instanceof MailServerBuilder) {
                MailServerBuilder builder = (MailServerBuilder)oMailServer;
                this.mailServer = builder.build();
            } else {
                throw new RuntimeException("Unsupported type: " + oMailServer.getClass() + " expected " + MailServer.class + " or " + MailServerBuilder.class);
            }
            log.info("starting mailserver");
            this.mailServer.start();
        }
    }

    public void doFilter(javax.servlet.ServletRequest req, javax.servlet.ServletResponse resp, FilterChain fc) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest hsr = (HttpServletRequest)req;
            String url = hsr.getRequestURI();
            for (String s : this.excludeMiltonPaths) {
                if (!url.startsWith(s)) continue;
                fc.doFilter(req, resp);
                return;
            }
        } else {
            fc.doFilter(req, resp);
            return;
        }
        this.doMiltonProcessing((HttpServletRequest)req, (HttpServletResponse)resp);
    }

    public void destroy() {
        this.context.close();
        if (this.httpManager != null) {
            this.httpManager.shutdown();
        }
        if (this.mailServer != null) {
            this.mailServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMiltonProcessing(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            MiltonServlet.setThreadlocals(req, resp);
            ServletRequest request = new ServletRequest(req, this.servletContext);
            ServletResponse response = new ServletResponse(resp);
            this.httpManager.process(request, response);
        }
        finally {
            MiltonServlet.clearThreadlocals();
            resp.getOutputStream().flush();
            resp.flushBuffer();
        }
    }
}

