/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.http.HttpManager;
import io.milton.servlet.DefaultMiltonConfigurator;
import io.milton.servlet.FilterConfigWrapper;
import io.milton.servlet.MiltonConfigurator;
import io.milton.servlet.MiltonServlet;
import io.milton.servlet.ServletRequest;
import io.milton.servlet.ServletResponse;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MiltonFilter.class);
    private FilterConfigWrapper config;
    private ServletContext servletContext;
    protected HttpManager httpManager;
    protected MiltonConfigurator configurator;
    private String[] excludeMiltonPaths;

    public void init(FilterConfig config) throws ServletException {
        try {
            this.config = new FilterConfigWrapper(config);
            this.servletContext = config.getServletContext();
            String configuratorClassName = config.getInitParameter("milton.configurator");
            this.configurator = configuratorClassName != null ? (MiltonConfigurator)DefaultMiltonConfigurator.instantiate(configuratorClassName) : new DefaultMiltonConfigurator();
            log.info("Using configurator: " + this.configurator.getClass());
            String sExcludePaths = config.getInitParameter("milton.exclude.paths");
            log.info("init: exclude paths: " + sExcludePaths);
            if (sExcludePaths != null) {
                this.excludeMiltonPaths = sExcludePaths.split(",");
            }
            this.httpManager = this.configurator.configure(this.config);
        }
        catch (ServletException ex) {
            log.error("Exception starting milton servlet", (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            log.error("Exception starting milton servlet", ex);
            throw new RuntimeException(ex);
        }
    }

    public void destroy() {
        log.debug("destroy");
        if (this.configurator == null) {
            return;
        }
        this.configurator.shutdown();
    }

    public void doFilter(javax.servlet.ServletRequest req, javax.servlet.ServletResponse resp, FilterChain fc) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest hsr = (HttpServletRequest)req;
            String url = hsr.getRequestURI();
            if (this.excludeMiltonPaths != null) {
                for (String s : this.excludeMiltonPaths) {
                    if (!url.startsWith(s)) continue;
                    fc.doFilter(req, resp);
                    return;
                }
            }
            this.doMiltonProcessing((HttpServletRequest)req, (HttpServletResponse)resp);
        } else {
            fc.doFilter(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMiltonProcessing(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            MiltonServlet.setThreadlocals(req, resp);
            ServletRequest request = new ServletRequest(req, this.servletContext);
            ServletResponse response = new ServletResponse(resp);
            this.httpManager.process(request, response);
        }
        finally {
            MiltonServlet.clearThreadlocals();
            resp.getOutputStream().flush();
            resp.flushBuffer();
        }
    }
}

