/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.http.HttpManager;
import io.milton.http.MultipleResourceFactory;
import io.milton.http.ResourceFactory;
import io.milton.servlet.Config;
import io.milton.servlet.Initable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitableMultipleResourceFactory
extends MultipleResourceFactory {
    private Logger log = LoggerFactory.getLogger(InitableMultipleResourceFactory.class);

    public InitableMultipleResourceFactory() {
    }

    public InitableMultipleResourceFactory(List<ResourceFactory> factories) {
        super(factories);
    }

    public void init(Config config, HttpManager manager) {
        String sFactories = config.getInitParameter("resource.factory.multiple");
        this.init(sFactories, config, manager);
    }

    protected void init(String sFactories, Config config, HttpManager manager) {
        String[] arr;
        this.log.debug("init: " + sFactories);
        for (String s : arr = sFactories.split(",")) {
            this.createFactory(s, config, manager);
        }
    }

    private void createFactory(String s, Config config, HttpManager manager) {
        Object o;
        Class<?> c;
        this.log.debug("createFactory: " + s);
        try {
            c = Class.forName(s);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(s, ex);
        }
        try {
            o = c.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(s, ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(s, ex);
        }
        ResourceFactory rf = (ResourceFactory)o;
        if (rf instanceof Initable) {
            Initable i = (Initable)rf;
            i.init(config, manager);
        }
        this.factories.add(rf);
    }

    public void destroy(HttpManager manager) {
        if (this.factories == null) {
            this.log.warn("factories is null");
            return;
        }
        for (ResourceFactory f : this.factories) {
            if (!(f instanceof Initable)) continue;
            ((Initable)f).destroy(manager);
        }
    }
}

