/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.config.HttpManagerBuilder;
import io.milton.http.AuthenticationHandler;
import io.milton.http.Filter;
import io.milton.http.HttpManager;
import io.milton.http.ResourceFactory;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.servlet.Config;
import io.milton.servlet.Initable;
import io.milton.servlet.MiltonConfigurator;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMiltonConfigurator
implements MiltonConfigurator {
    private static final Logger log = LoggerFactory.getLogger(DefaultMiltonConfigurator.class);
    protected HttpManagerBuilder builder;
    protected List<Initable> initables;
    protected HttpManager httpManager;

    public DefaultMiltonConfigurator() {
        try {
            Class<?> builderClass = Class.forName("io.milton.ent.config.HttpManagerBuilderEnt");
            this.builder = (HttpManagerBuilder)builderClass.newInstance();
            log.info("Using enterprise builder: " + this.builder.getClass());
        }
        catch (InstantiationException ex) {
            log.info("Couldnt instantiate enterprise builder, DAV level 2 and beyond features will not be available");
            this.builder = new HttpManagerBuilder();
        }
        catch (IllegalAccessException ex) {
            log.info("Couldnt instantiate enterprise builder, DAV level 2 and beyond features will not be available");
            this.builder = new HttpManagerBuilder();
        }
        catch (ClassNotFoundException ex) {
            log.info("Couldnt instantiate enterprise builder, DAV level 2 and beyond features will not be available");
            this.builder = new HttpManagerBuilder();
        }
    }

    @Override
    public HttpManager configure(Config config) throws ServletException {
        String resourceFactoryClassName;
        log.info("Listing all config parameters:");
        for (String s : config.getInitParameterNames()) {
            log.info(" " + s + " = " + config.getInitParameter(s));
        }
        String authHandlers = config.getInitParameter("authenticationHandlers");
        if (authHandlers != null) {
            this.initAuthHandlers(authHandlers);
        }
        if ((resourceFactoryClassName = config.getInitParameter("resource.factory.class")) != null) {
            ResourceFactory rf = (ResourceFactory)DefaultMiltonConfigurator.instantiate(resourceFactoryClassName);
            this.builder.setMainResourceFactory(rf);
        } else {
            log.warn("No custom ResourceFactory class name provided in resource.factory.class");
        }
        String responseHandlerClassName = config.getInitParameter("response.handler.class");
        if (responseHandlerClassName != null) {
            WebDavResponseHandler davResponseHandler = (WebDavResponseHandler)DefaultMiltonConfigurator.instantiate(responseHandlerClassName);
            this.builder.setWebdavResponseHandler(davResponseHandler);
        }
        ArrayList<Filter> filters = null;
        List<String> params = config.getInitParameterNames();
        for (String paramName : params) {
            if (!paramName.startsWith("filter_")) continue;
            String filterClass = config.getInitParameter(paramName);
            Filter f = (Filter)DefaultMiltonConfigurator.instantiate(filterClass);
            if (filters == null) {
                filters = new ArrayList<Filter>();
            }
            filters.add(f);
        }
        if (filters != null) {
            this.builder.setFilters(filters);
        }
        this.build();
        this.initables = new ArrayList<Initable>();
        this.checkAddInitable(this.initables, this.builder.getAuthenticationHandlers());
        this.checkAddInitable(this.initables, this.builder.getMainResourceFactory());
        this.checkAddInitable(this.initables, this.builder.getWebdavResponseHandler());
        this.checkAddInitable(this.initables, this.builder.getFilters());
        for (Initable i : this.initables) {
            i.init(config, this.httpManager);
        }
        return this.httpManager;
    }

    protected void build() {
        this.httpManager = this.builder.buildHttpManager();
    }

    @Override
    public void shutdown() {
        if (this.httpManager != null) {
            this.httpManager.shutdown();
        }
        if (this.initables != null) {
            for (Initable i : this.initables) {
                i.destroy(this.httpManager);
            }
        }
    }

    private void initAuthHandlers(String classNames) throws ServletException {
        List<String> authHandlers = this.loadAuthHandlersIfAny(classNames);
        if (authHandlers == null) {
            return;
        }
        ArrayList<AuthenticationHandler> list = new ArrayList<AuthenticationHandler>();
        for (String authHandlerClassName : authHandlers) {
            Object o = DefaultMiltonConfigurator.instantiate(authHandlerClassName);
            if (o instanceof AuthenticationHandler) {
                AuthenticationHandler auth = (AuthenticationHandler)o;
                list.add(auth);
                continue;
            }
            throw new ServletException("Class: " + authHandlerClassName + " is not a: " + AuthenticationHandler.class.getCanonicalName());
        }
        this.builder.setAuthenticationHandlers(list);
    }

    public static <T> T instantiate(String className) throws ServletException {
        try {
            Class<?> c = Class.forName(className);
            Object rf = c.newInstance();
            return (T)rf;
        }
        catch (Throwable ex) {
            throw new ServletException("Failed to instantiate: " + className, ex);
        }
    }

    private List<String> loadAuthHandlersIfAny(String initParameter) {
        if (initParameter == null) {
            return null;
        }
        String[] arr = initParameter.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String s : arr) {
            if ((s = s.trim()).length() <= 0) continue;
            list.add(s);
        }
        return list;
    }

    private void checkAddInitable(List<Initable> initables, Object o) {
        if (o instanceof Initable) {
            initables.add((Initable)o);
        } else if (o instanceof List) {
            for (Object o2 : (List)o) {
                this.checkAddInitable(initables, o2);
            }
        }
    }
}

