/*
 * Decompiled with CFR 0.152.
 */
package io.milton.restlet;

import io.milton.http.AbstractResponse;
import io.milton.http.Cookie;
import io.milton.http.Response;
import io.milton.restlet.CookieAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.engine.adapter.HttpResponse;
import org.restlet.engine.header.Header;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class ResponseAdapter
extends AbstractResponse {
    protected final HttpResponse target;

    ResponseAdapter(HttpResponse target) {
        this.target = target;
    }

    public HttpResponse getTarget() {
        return this.target;
    }

    protected Series<Header> getRawHeaders() {
        return this.getTarget().getHttpCall().getResponseHeaders();
    }

    public void setStatus(Response.Status status) {
        this.getTarget().setStatus(Status.valueOf((int)status.code));
    }

    public void sendError(Response.Status status, String message) {
        this.setStatus(status);
    }

    public Response.Status getStatus() {
        return Response.Status.SC_OK.fromCode(this.getTarget().getStatus().getCode());
    }

    public Map<String, String> getHeaders() {
        return this.getRawHeaders().getValuesMap();
    }

    public void setAuthenticateHeader(List<String> challenges) {
        for (String ch : challenges) {
            this.getRawHeaders().add("WWW-Authenticate", ch);
        }
    }

    public void setNonStandardHeader(String code, String value) {
        this.getRawHeaders().add(code, value);
    }

    public String getNonStandardHeader(String code) {
        return this.getRawHeaders().getValues(code);
    }

    public Cookie setCookie(Cookie cookie) {
        this.getTarget().getCookieSettings().add((Object)new CookieAdapter(cookie).getTarget());
        return cookie;
    }

    public Cookie setCookie(String name, String value) {
        CookieAdapter cookie = new CookieAdapter(name, value);
        this.getTarget().getCookieSettings().add((Object)cookie.getTarget());
        return cookie;
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("No direct access to response streams in Restlet, set the response entity instead!");
    }

    public void close() {
    }

    public void setTargetEntity() {
        final Response.Entity entity = this.getEntity();
        if (entity != null) {
            MediaType contentType = MediaType.valueOf((String)this.getContentTypeHeader());
            this.getTarget().setEntity((Representation)new OutputRepresentation(contentType){

                public void write(OutputStream outputStream) throws IOException {
                    try {
                        entity.write((Response)ResponseAdapter.this, outputStream);
                    }
                    catch (IOException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
    }
}

