/*
 * Decompiled with CFR 0.152.
 */
package io.milton.proxy;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

class DataConn {
    public boolean debug = false;
    public String debugname = null;
    public boolean error = false;
    protected Socket sconn;
    protected InputStream is;
    protected OutputStream os;

    public DataConn() {
    }

    public DataConn(String szhost, int port) {
        try {
            this.connect(new Socket(InetAddress.getByName(szhost), port));
        }
        catch (Throwable T) {
            System.err.println("new dataconn ERR: " + T.getMessage());
            this.error = true;
        }
    }

    public DataConn(InetAddress rhost, int port) {
        try {
            this.connect(new Socket(rhost, port));
        }
        catch (Throwable T) {
            System.err.println("new dataconn ERR: " + T.getMessage());
            this.error = true;
        }
    }

    public DataConn(Socket _s) {
        this.connect(_s);
    }

    public void setDebug(boolean _debug) {
        this.debug = _debug;
    }

    protected void finalize() {
        this.close();
    }

    protected void connect(Socket _s) {
        this.sconn = _s;
        this.connect();
    }

    protected void connect() {
        this.error = false;
        try {
            this.is = this.sconn.getInputStream();
            this.os = this.sconn.getOutputStream();
        }
        catch (Throwable T) {
            this.exception(T);
            this.error = true;
        }
    }

    protected void close() {
        if (this.sconn == null) {
            return;
        }
        try {
            this.os = null;
            this.is = null;
            this.sconn.close();
            this.sconn = null;
        }
        catch (Throwable E) {
            System.err.println("dataconn.close ERR: " + E.getMessage());
            this.error = true;
        }
    }

    protected final void write(String d) {
        this.write(d.getBytes());
    }

    protected final void write(byte[] d) {
        if (this.error) {
            return;
        }
        try {
            this.os.write(d);
            this.os.flush();
            this.debuglog(false, d);
            this.log(false, d);
        }
        catch (Throwable T) {
            this.exception(T);
            this.error = true;
        }
    }

    protected final byte[] read() {
        if (this.error) {
            return null;
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException IE) {
            return null;
        }
        try {
            int iavail = this.is.available();
            if (iavail > 0) {
                byte[] d = new byte[iavail];
                this.is.read(d);
                this.debuglog(true, d);
                this.log(true, d);
                return d;
            }
        }
        catch (Throwable T) {
            this.exception(T);
            this.error = true;
        }
        return null;
    }

    protected final void debuglog(boolean isread, byte[] d) {
        if (!this.debug) {
            return;
        }
        if (this.debugname != null) {
            System.err.print(this.debugname + " ");
        }
        if (isread) {
            System.err.print("R:");
        } else {
            System.err.print("W:");
        }
        System.err.println(" " + d.length + " bytes");
    }

    protected void log(boolean isread, byte[] d) {
    }

    protected void exception(Throwable T) {
        String m = "EXCEPTION: " + T.getMessage();
        System.err.println(m);
        if (!(T instanceof SocketException)) {
            T.printStackTrace();
        }
    }
}

