/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import io.milton.common.LogUtils;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.values.ValueAndType;
import io.milton.ldap.Condition;
import io.milton.ldap.Conditions;
import io.milton.ldap.Ldap;
import io.milton.ldap.LdapFilter;
import io.milton.ldap.LdapPrincipal;
import io.milton.ldap.LdapPropertyMapper;
import io.milton.ldap.LdapResponseHandler;
import io.milton.ldap.SearchManager;
import io.milton.ldap.UserFactory;
import io.milton.resource.LdapContact;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SearchRunnable.class);
    private final UserFactory userFactory;
    private final int currentMessageId;
    private final SearchManager searchManager;
    private final String dn;
    private final int scope;
    private final int sizeLimit;
    private final int timelimit;
    private final LdapFilter ldapFilter;
    private final Set<String> returningAttributes;
    private final LdapPropertyMapper propertyMapper;
    private final Conditions conditions;
    private UUID uuid;
    private boolean abandon;
    private final LdapResponseHandler responseHandler;
    private final LdapPrincipal user;

    protected SearchRunnable(UserFactory userFactory, LdapPropertyMapper propertyMapper, int currentMessageId, String dn, int scope, int sizeLimit, int timelimit, LdapFilter ldapFilter, Set<String> returningAttributes, LdapResponseHandler ldapResponseHandler, LdapPrincipal user, SearchManager searchManager) {
        this.userFactory = userFactory;
        this.searchManager = searchManager;
        this.user = user;
        this.responseHandler = ldapResponseHandler;
        this.propertyMapper = propertyMapper;
        this.conditions = new Conditions(propertyMapper);
        this.currentMessageId = currentMessageId;
        this.dn = dn;
        this.scope = scope;
        this.sizeLimit = sizeLimit;
        this.timelimit = timelimit;
        this.ldapFilter = ldapFilter;
        this.returningAttributes = returningAttributes;
    }

    public void abandon() {
        this.abandon = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int size = 0;
            LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_SEARCH", this.currentMessageId, this.dn, this.scope, this.sizeLimit, this.timelimit, this.ldapFilter.toString(), this.returningAttributes});
            if (this.scope == 0) {
                log.debug("Check type of search... scope is BASE OBJECT");
                if ("".equals(this.dn)) {
                    size = 1;
                    log.info("send root DSE");
                    this.responseHandler.sendRootDSE(this.currentMessageId);
                } else if ("ou=people".equals(this.dn)) {
                    size = 1;
                    log.info("send base context");
                    this.responseHandler.sendBaseContext(this.currentMessageId);
                } else if (this.dn.startsWith("uid=") && this.dn.indexOf(44) > 0) {
                    if (this.user != null) {
                        String uid = this.dn.substring("uid=".length(), this.dn.indexOf(44));
                        Set<LdapContact> persons = null;
                        try {
                            Integer.parseInt(uid);
                            persons = this.contactFind(this.conditions.isEqualTo("imapUid", uid), this.returningAttributes, this.sizeLimit);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (persons == null || persons.isEmpty()) {
                            List<LdapContact> galContacts = null;
                            try {
                                log.info("do GAL search: " + uid);
                                galContacts = this.userFactory.galFind(this.conditions.isEqualTo("imapUid", uid), this.sizeLimit);
                            }
                            catch (NotAuthorizedException ex) {
                                log.error("not auth", (Throwable)ex);
                            }
                            catch (BadRequestException ex) {
                                log.error("bad req", (Throwable)ex);
                            }
                            if (galContacts != null && galContacts.size() > 0) {
                                LdapContact person = (LdapContact)galContacts.get(0);
                                if (persons == null) {
                                    persons = new HashSet<LdapContact>();
                                }
                                persons.add(person);
                            }
                        }
                        size = persons == null ? 0 : persons.size();
                        try {
                            this.sendPersons(this.currentMessageId, this.dn.substring(this.dn.indexOf(44)), persons, this.returningAttributes);
                        }
                        catch (NotAuthorizedException ex) {
                            log.error("Not authorised", (Throwable)ex);
                        }
                        catch (BadRequestException ex) {
                            log.error("bad req", (Throwable)ex);
                        }
                    } else {
                        LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_SEARCH_ANONYMOUS_ACCESS_FORBIDDEN", this.currentMessageId, this.dn});
                    }
                } else {
                    LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_SEARCH_INVALID_DN (1)", this.currentMessageId, this.dn});
                }
            } else if ("cn=computers, o=od".equals(this.dn) || "cn=computers,o=od".equals(this.dn)) {
                size = 1;
                log.info("send computer context");
                this.responseHandler.sendComputerContext(this.currentMessageId, this.returningAttributes);
            } else if (this.dn.equals("") || "ou=people".equalsIgnoreCase(this.dn) || "cn=users, o=od".equalsIgnoreCase(this.dn) || "c=US".equals(this.dn) || "cn=users, ou=people".equalsIgnoreCase(this.dn)) {
                log.info("not a weird search... check for normal conditions");
                if (this.user != null) {
                    log.debug("we have a user...");
                    HashSet<LdapContact> persons = new HashSet<LdapContact>();
                    if (this.ldapFilter.isFullSearch()) {
                        log.info("do personcal contact search");
                        Set<LdapContact> contacts = this.contactFind(null, this.returningAttributes, this.sizeLimit);
                        LogUtils.debug((Logger)log, (Object[])new Object[]{"fullSearch: results:", contacts.size()});
                        for (LdapContact person : contacts) {
                            persons.add(person);
                            if (persons.size() != this.sizeLimit) continue;
                            break;
                        }
                        for (char c = 'A'; c <= 'Z'; c = (char)(c + 1)) {
                            if (!this.abandon && persons.size() < this.sizeLimit) {
                                Condition startsWith = this.conditions.startsWith("cn", String.valueOf(c));
                                List<LdapContact> galContacts = null;
                                try {
                                    log.info("now do GAL search");
                                    galContacts = this.userFactory.galFind(startsWith, this.sizeLimit);
                                }
                                catch (NotAuthorizedException ex) {
                                    log.error("not auth", (Throwable)ex);
                                }
                                catch (BadRequestException ex) {
                                    log.error("bad req", (Throwable)ex);
                                }
                                if (galContacts != null) {
                                    LogUtils.debug((Logger)log, (Object[])new Object[]{"doSearch: results:", contacts.size()});
                                    for (LdapContact person : galContacts) {
                                        persons.add(person);
                                        if (persons.size() != this.sizeLimit) continue;
                                        break;
                                    }
                                }
                            }
                            if (persons.size() != this.sizeLimit) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        log.info("do personcal contact search only");
                        Condition filter = this.ldapFilter.getContactSearchFilter();
                        LogUtils.debug((Logger)log, (Object[])new Object[]{"not full search:", filter});
                        if (this.ldapFilter.isFullSearch() || filter != null) {
                            Set<LdapContact> contacts = this.contactFind(filter, this.returningAttributes, this.sizeLimit);
                            for (LdapContact person : contacts) {
                                persons.add(person);
                                if (persons.size() != this.sizeLimit) continue;
                                log.debug("EXceeded size limit1");
                                break;
                            }
                            LogUtils.trace((Logger)log, (Object[])new Object[]{"local contacts result size: ", persons.size()});
                            if (!this.abandon && persons.size() < this.sizeLimit) {
                                List<LdapContact> galContacts = null;
                                try {
                                    galContacts = this.ldapFilter.findInGAL(this.user, this.returningAttributes, this.sizeLimit - persons.size());
                                }
                                catch (NotAuthorizedException ex) {
                                    log.error("not auth", (Throwable)ex);
                                }
                                catch (BadRequestException ex) {
                                    log.error("bad req", (Throwable)ex);
                                }
                                if (galContacts != null) {
                                    LogUtils.trace((Logger)log, (Object[])new Object[]{"gal contacts result size: ", galContacts.size()});
                                    for (LdapContact person : galContacts) {
                                        if (persons.size() >= this.sizeLimit) {
                                            log.debug("EXceeded size limit2");
                                            break;
                                        }
                                        LogUtils.trace((Logger)log, (Object[])new Object[]{"add contact to results: ", person.getName()});
                                        persons.add(person);
                                    }
                                }
                            }
                        }
                    }
                    LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_SEARCH_FOUND_RESULTS", this.currentMessageId, persons.size()});
                    try {
                        this.sendPersons(this.currentMessageId, ", " + this.dn, persons, this.returningAttributes);
                    }
                    catch (NotAuthorizedException ex) {
                        log.error("not auth", (Throwable)ex);
                    }
                    catch (BadRequestException ex) {
                        log.error("bad req", (Throwable)ex);
                    }
                    LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_SEARCH_END", this.currentMessageId});
                } else {
                    LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_SEARCH_ANONYMOUS_ACCESS_FORBIDDEN", this.currentMessageId, this.dn});
                }
            } else if (this.dn != null && this.dn.length() > 0 && !"cn=config, o=od".equals(this.dn) && !"cn=groups, o=od".equals(this.dn)) {
                LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_SEARCH_INVALID_DN (2)", this.currentMessageId, this.dn});
                log.debug("DN is not equal to: cn=config, o=od or cn=groups, o=od or any other valid pattern. Is: " + this.dn);
            } else {
                log.warn("Search criteria didnt match any of the expected patterns. Perhaps the user name is missing a context? DN=" + this.dn + ", expected something like: " + "cn=users, o=od");
            }
            if (size > 1 && size == this.sizeLimit) {
                LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_SEARCH_SIZE_LIMIT_EXCEEDED", this.currentMessageId});
                this.responseHandler.sendClient(this.currentMessageId, 101, 4, "");
            } else {
                log.debug("No search results");
                LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_SEARCH_SUCCESS", this.currentMessageId});
                this.responseHandler.sendClient(this.currentMessageId, 101, 0, "");
            }
        }
        catch (SocketException e) {
            log.warn("closed connection", (Throwable)e);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            try {
                this.responseHandler.sendErr(this.currentMessageId, 101, e);
            }
            catch (IOException e2) {
                LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_EXCEPTION_SENDING_ERROR_TO_CLIENT", e2});
            }
        }
        finally {
            log.debug("search complete");
            this.searchManager.searchComplete(this.uuid, this.currentMessageId);
        }
    }

    public Set<LdapContact> contactFind(Condition condition, Set<String> returningAttributes, int maxCount) throws IOException {
        HashSet<LdapContact> results = new HashSet<LdapContact>();
        List<LdapContact> contacts = this.user.searchContacts(condition, maxCount);
        LogUtils.trace((Logger)log, (Object[])new Object[]{"contactFind: contacts size:", contacts.size()});
        for (LdapContact contact : contacts) {
            results.add(contact);
        }
        return results;
    }

    private void sendPersons(int currentMessageId, String baseContext, Set<LdapContact> persons, Set<String> returningAttributes) throws IOException, NotAuthorizedException, BadRequestException {
        LogUtils.debug((Logger)log, (Object[])new Object[]{"sendPersons", baseContext, "size:", persons.size()});
        boolean needObjectClasses = returningAttributes.contains("objectclass") || returningAttributes.isEmpty();
        boolean returnAllAttributes = returningAttributes.isEmpty();
        if (persons.isEmpty()) {
            log.warn("No contacts to send! -------------------");
        }
        for (LdapContact person : persons) {
            if (this.abandon) {
                log.warn("Abandon flag is set, so exiting send!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                break;
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            Set<LdapPropertyMapper.LdapMappedProp> props = this.propertyMapper.mapProperties(returnAllAttributes, returningAttributes, (PropFindableResource)person);
            response.put("uid", person.getName());
            for (LdapPropertyMapper.LdapMappedProp ldapMappedProp : props) {
                ValueAndType vt;
                try {
                    vt = this.propertyMapper.getProperty(ldapMappedProp.mappedName, (Resource)person);
                }
                catch (NotAuthorizedException ex) {
                    vt = null;
                }
                if (vt == null) {
                    LogUtils.trace((Logger)log, (Object[])new Object[]{"sendPersons: property not found: ldap property: ", ldapMappedProp.ldapName, " - dav prop: ", ldapMappedProp.mappedName, "resource: ", person.getClass()});
                    continue;
                }
                if (vt.getValue() == null) continue;
                response.put(ldapMappedProp.ldapName, vt.getValue());
            }
            for (Map.Entry entry : Ldap.STATIC_ATTRIBUTE_MAP.entrySet()) {
                String ldapAttribute = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null || !returnAllAttributes && !returningAttributes.contains(ldapAttribute)) continue;
                response.put(ldapAttribute, value);
            }
            if (needObjectClasses) {
                response.put("objectClass", Ldap.PERSON_OBJECT_CLASSES);
            }
            if (returnAllAttributes || returningAttributes.contains("apple-generateduid")) {
                String mail = (String)response.get("mail");
                if (mail != null) {
                    response.put("apple-generateduid", mail.replaceAll("@", "__AT__"));
                } else {
                    response.put("apple-generateduid", response.get("uid"));
                }
            }
            if (this.user.getName().equals(response.get("uid")) && returningAttributes.contains("uidnumber")) {
                response.put("uidnumber", this.user.getName());
            }
            LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_SEARCH_SEND_PERSON", currentMessageId, response.get("uid"), baseContext, response});
            this.responseHandler.sendEntry(currentMessageId, "uid=" + response.get("uid") + baseContext, response);
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }
}

