/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.ldap.Condition;
import io.milton.resource.LdapContact;
import java.util.ArrayList;
import java.util.List;

public class MultiCondition
implements Condition {
    protected final Condition.Operator operator;
    protected final List<Condition> conditions;

    protected MultiCondition(Condition.Operator operator, Condition ... conditions) {
        this.operator = operator;
        this.conditions = new ArrayList<Condition>();
        for (Condition condition : conditions) {
            if (condition == null) continue;
            this.conditions.add(condition);
        }
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition.Operator getOperator() {
        return this.operator;
    }

    public void add(Condition condition) {
        if (condition != null) {
            this.conditions.add(condition);
        }
    }

    @Override
    public boolean isEmpty() {
        boolean isEmpty = true;
        for (Condition condition : this.conditions) {
            if (condition.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    @Override
    public boolean isMatch(LdapContact contact) throws NotAuthorizedException, BadRequestException {
        if (this.operator == Condition.Operator.And) {
            for (Condition condition : this.conditions) {
                if (condition.isMatch(contact)) continue;
                return false;
            }
            return true;
        }
        if (this.operator == Condition.Operator.Or) {
            for (Condition condition : this.conditions) {
                if (!condition.isMatch(contact)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

