/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import com.sun.jndi.ldap.BerDecoder;
import io.milton.common.LogUtils;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.ldap.LdapFilter;
import io.milton.ldap.LdapParser;
import io.milton.ldap.LdapPrincipal;
import io.milton.ldap.LdapPropertyMapper;
import io.milton.ldap.LdapResponseHandler;
import io.milton.ldap.LdapTransactionManager;
import io.milton.ldap.LineReaderInputStream;
import io.milton.ldap.SearchManager;
import io.milton.ldap.SearchRunnable;
import io.milton.ldap.UserFactory;
import io.milton.property.PropertySource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnection
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(LdapConnection.class);
    protected SaslServer saslServer;
    protected BufferedInputStream is;
    private final UserFactory userFactory;
    private final LdapPropertyMapper propertyMapper;
    private final LdapResponseHandler responseHandler;
    private final LdapParser ldapParser;
    private final Socket client;
    private final SearchManager searchManager;
    private final LdapTransactionManager txManager;
    private LdapPrincipal user;
    private LineReaderInputStream in;
    private final OutputStream os;
    private String userName;
    private String password;
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public LdapConnection(Socket clientSocket, UserFactory userSessionFactory, List<PropertySource> propertySources, SearchManager searchManager, LdapTransactionManager txManager) {
        super(LdapConnection.class.getSimpleName() + '-' + clientSocket.getPort());
        this.searchManager = searchManager;
        this.client = clientSocket;
        this.txManager = txManager;
        this.setDaemon(true);
        this.userFactory = userSessionFactory;
        this.propertyMapper = new LdapPropertyMapper(new PropFindPropertyBuilder(propertySources));
        try {
            this.is = new BufferedInputStream(this.client.getInputStream());
            this.os = new BufferedOutputStream(this.client.getOutputStream());
        }
        catch (IOException e) {
            this.close();
            throw new RuntimeException(e);
        }
        this.responseHandler = new LdapResponseHandler(this.client, this.os);
        this.ldapParser = new LdapParser(this.propertyMapper, this.responseHandler, this.userFactory);
        System.out.println("Created LDAP Connection handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] inbuf = new byte[2048];
        try {
            int offset;
            int bytesread;
            while ((bytesread = this.is.read(inbuf, offset = 0, 1)) >= 0) {
                int bytesleft;
                int seqlen;
                System.out.println("read bytes: " + bytesread);
                if (inbuf[offset++] != 48) continue;
                bytesread = this.is.read(inbuf, offset, 1);
                if (bytesread < 0) {
                    break;
                }
                if (((seqlen = inbuf[offset++]) & 0x80) == 128) {
                    int br;
                    int seqlenlen = seqlen & 0x7F;
                    boolean eos = false;
                    for (bytesread = 0; bytesread < seqlenlen; bytesread += br) {
                        br = this.is.read(inbuf, offset + bytesread, seqlenlen - bytesread);
                        if (br >= 0) continue;
                        eos = true;
                        break;
                    }
                    if (eos) {
                        break;
                    }
                    seqlen = 0;
                    for (int i = 0; i < seqlenlen; ++i) {
                        seqlen = (seqlen << 8) + (inbuf[offset + i] & 0xFF);
                    }
                    offset += bytesread;
                }
                if (offset + (bytesleft = seqlen) > inbuf.length) {
                    byte[] nbuf = new byte[offset + bytesleft];
                    System.arraycopy(inbuf, 0, nbuf, 0, offset);
                    inbuf = nbuf;
                }
                while (bytesleft > 0 && (bytesread = this.is.read(inbuf, offset, bytesleft)) >= 0) {
                    offset += bytesread;
                    bytesleft -= bytesread;
                }
                this.handleRequest(inbuf, offset);
            }
        }
        catch (SocketException e) {
            log.debug("LOG_CONNECTION_CLOSED");
        }
        catch (SocketTimeoutException e) {
            log.debug("LOG_CLOSE_CONNECTION_ON_TIMEOUT");
        }
        catch (Exception e) {
            log.error("err", (Throwable)e);
            try {
                this.responseHandler.sendErr(0, 97, e);
            }
            catch (IOException e2) {
                log.warn("LOG_EXCEPTION_SENDING_ERROR_TO_CLIENT", (Throwable)e2);
            }
        }
        finally {
            this.searchManager.cancelAllSearches(this);
            this.close();
        }
    }

    protected void handleRequest(final byte[] inbuf, final int offset) throws IOException {
        try {
            this.txManager.tx(new Runnable(){

                @Override
                public void run() {
                    try {
                        LdapConnection.this._handleRequest(inbuf, offset);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
        catch (Throwable e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    protected void _handleRequest(byte[] inbuf, int offset) throws IOException {
        BerDecoder reqBer = new BerDecoder(inbuf, 0, offset);
        int currentMessageId = 0;
        try {
            reqBer.parseSeq(null);
            currentMessageId = reqBer.parseInt();
            int requestOperation = reqBer.peekByte();
            if (requestOperation == 96) {
                reqBer.parseSeq(null);
                this.responseHandler.setVersion(reqBer.parseInt());
                this.userName = reqBer.parseString(this.responseHandler.isLdapV3());
                log.info("Bind user name: " + this.userName);
                if (reqBer.peekByte() == 163) {
                    int status;
                    byte[] serverResponse;
                    reqBer.parseSeq(null);
                    String mechanism = reqBer.parseString(this.responseHandler.isLdapV3());
                    CallbackHandler callbackHandler = new CallbackHandler(){

                        @Override
                        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                            for (Callback callback : callbacks) {
                                if (!(callback instanceof NameCallback)) continue;
                                LdapConnection.this.userName = ((NameCallback)callback).getDefaultName();
                                LdapConnection.this.password = LdapConnection.this.userFactory.getUserPassword(LdapConnection.this.userName);
                            }
                            for (Callback callback : callbacks) {
                                if (callback instanceof AuthorizeCallback) {
                                    ((AuthorizeCallback)callback).setAuthorized(true);
                                    continue;
                                }
                                if (!(callback instanceof PasswordCallback) || LdapConnection.this.password == null) continue;
                                ((PasswordCallback)callback).setPassword(LdapConnection.this.password.toCharArray());
                            }
                        }
                    };
                    if (reqBer.bytesLeft() > 0 && this.saslServer != null) {
                        byte[] clientResponse = reqBer.parseOctetString(4, null);
                        serverResponse = this.saslServer.evaluateResponse(clientResponse);
                        status = 0;
                        LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_BIND_USER", currentMessageId, this.userName});
                        this.user = this.userFactory.getUser(this.userName, this.password);
                        if (this.user != null) {
                            LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_BIND_SUCCESS"});
                        } else {
                            LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_BIND", "No user! " + this.userName});
                        }
                    } else {
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("javax.security.sasl.qop", "auth,auth-int");
                        this.saslServer = Sasl.createSaslServer(mechanism, "ldap", this.client.getLocalAddress().getHostAddress(), properties, callbackHandler);
                        serverResponse = this.saslServer.evaluateResponse(EMPTY_BYTE_ARRAY);
                        status = 14;
                    }
                    this.responseHandler.sendBindResponse(currentMessageId, status, serverResponse);
                } else {
                    this.password = reqBer.parseStringWithTag(128, this.responseHandler.isLdapV3(), null);
                    if (this.userName.length() > 0 && this.password.length() > 0) {
                        log.debug("LOG_LDAP_REQ_BIND_USER", (Object)currentMessageId, (Object)this.userName);
                        try {
                            this.user = this.userFactory.getUser(this.userName, this.password);
                            LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_BIND_SUCCESS"});
                            this.responseHandler.sendClient(currentMessageId, 97, 0, "");
                        }
                        catch (IOException e) {
                            LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_BIND_INVALID_CREDENTIALS"});
                            this.responseHandler.sendClient(currentMessageId, 97, 49, "");
                        }
                    } else {
                        LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_BIND_ANONYMOUS", currentMessageId});
                        this.responseHandler.sendClient(currentMessageId, 97, 0, "");
                    }
                }
            } else if (requestOperation == 66) {
                log.debug("LOG_LDAP_REQ_UNBIND", (Object)currentMessageId);
                if (this.user != null) {
                    this.user = null;
                }
            } else if (requestOperation == 99) {
                reqBer.parseSeq(null);
                String dn = reqBer.parseString(this.responseHandler.isLdapV3());
                log.info("Parsed DN: " + dn);
                int scope = reqBer.parseEnumeration();
                reqBer.parseEnumeration();
                int sizeLimit = reqBer.parseInt();
                if (sizeLimit > 100 || sizeLimit == 0) {
                    sizeLimit = 100;
                }
                int timelimit = reqBer.parseInt();
                reqBer.parseBoolean();
                LdapFilter ldapFilter = this.ldapParser.parseFilter(reqBer, this.user, this.userName);
                Set<String> returningAttributes = this.ldapParser.parseReturningAttributes(reqBer);
                SearchRunnable searchRunnable = new SearchRunnable(this.userFactory, this.propertyMapper, currentMessageId, dn, scope, sizeLimit, timelimit, ldapFilter, returningAttributes, this.responseHandler, this.user, this.searchManager);
                if ("ou=people".equalsIgnoreCase(dn) || "cn=users, o=od".equalsIgnoreCase(dn) || "cn=users, ou=people".equalsIgnoreCase(dn)) {
                    this.searchManager.beginAsyncSearch(this, currentMessageId, searchRunnable);
                } else {
                    this.searchManager.search(this, searchRunnable);
                }
            } else if (requestOperation == 80) {
                this.searchManager.abandonSearch(this, currentMessageId, reqBer);
            } else {
                LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_UNSUPPORTED_OPERATION", requestOperation});
                this.responseHandler.sendClient(currentMessageId, 101, 80, "Unsupported operation");
            }
        }
        catch (IOException e) {
            this.responseHandler.dumpBer(inbuf, offset);
            try {
                this.responseHandler.sendErr(currentMessageId, 101, e);
            }
            catch (IOException e2) {
                log.debug("LOG_EXCEPTION_SENDING_ERROR_TO_CLIENT", (Throwable)e2);
            }
            throw e;
        }
    }

    public final void close() {
        IOUtils.closeQuietly((InputStream)this.in);
        IOUtils.closeQuietly((OutputStream)this.os);
        try {
            this.client.close();
        }
        catch (IOException e2) {
            log.warn("LOG_EXCEPTION_CLOSING_CLIENT_SOCKET", (Throwable)e2);
        }
    }
}

