/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.http.webdav.WebDavProtocol;
import io.milton.property.PropertySource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class PropertyMap {
    private final Map<String, StandardProperty> writersMap = new HashMap<String, StandardProperty>();
    private final String nameSpace;

    public PropertyMap(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public boolean hasProperty(QName name) {
        if (!name.getNamespaceURI().equals(this.nameSpace)) {
            return false;
        }
        StandardProperty pa = this.writersMap.get(name.getLocalPart());
        return pa != null;
    }

    public Object getProperty(QName name, Resource r) {
        if (!name.getNamespaceURI().equals(this.nameSpace)) {
            return null;
        }
        StandardProperty pa = this.writersMap.get(name.getLocalPart());
        if (pa == null) {
            return null;
        }
        if (r instanceof PropFindableResource) {
            return pa.getValue((PropFindableResource)r);
        }
        return null;
    }

    public void setProperty(QName name, Resource r, Object val) {
        if (!name.getNamespaceURI().equals(this.nameSpace)) {
            return;
        }
        StandardProperty pa = this.writersMap.get(name.getLocalPart());
        if (pa == null) {
            return;
        }
        if (!(pa instanceof WritableStandardProperty)) {
            return;
        }
        WritableStandardProperty wsp = (WritableStandardProperty)pa;
        if (!(r instanceof PropFindableResource)) {
            return;
        }
        wsp.setValue((PropFindableResource)r, val);
    }

    public PropertySource.PropertyMetaData getPropertyMetaData(QName name, Resource r) {
        if (!name.getNamespaceURI().equals(this.nameSpace)) {
            return PropertySource.PropertyMetaData.UNKNOWN;
        }
        StandardProperty pa = this.writersMap.get(name.getLocalPart());
        if (pa == null) {
            return PropertySource.PropertyMetaData.UNKNOWN;
        }
        if (r instanceof PropFindableResource) {
            if (pa instanceof WritableStandardProperty) {
                return new PropertySource.PropertyMetaData(PropertySource.PropertyAccessibility.WRITABLE, pa.getValueClass());
            }
            return new PropertySource.PropertyMetaData(PropertySource.PropertyAccessibility.READ_ONLY, pa.getValueClass());
        }
        return PropertySource.PropertyMetaData.UNKNOWN;
    }

    public List<QName> getAllPropertyNames(Resource r) {
        ArrayList<QName> list = new ArrayList<QName>();
        for (String nm : this.writersMap.keySet()) {
            QName qname = new QName(WebDavProtocol.NS_DAV.getName(), nm);
            list.add(qname);
        }
        return list;
    }

    public void add(StandardProperty pw) {
        this.writersMap.put(pw.fieldName(), pw);
    }

    public static interface WritableStandardProperty<T>
    extends StandardProperty<T> {
        public void setValue(PropFindableResource var1, T var2);
    }

    public static interface StandardProperty<T> {
        public String fieldName();

        public T getValue(PropFindableResource var1);

        public Class getValueClass();
    }
}

