/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.http.HttpManager;
import io.milton.http.XmlWriter;
import io.milton.http.values.ValueWriters;
import io.milton.http.webdav.PropFindResponse;
import io.milton.http.webdav.PropFindXmlGeneratorHelper;
import io.milton.http.webdav.WebDavProtocol;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropFindXmlGenerator {
    private static final Logger log = LoggerFactory.getLogger(PropFindXmlGenerator.class);
    private final PropFindXmlGeneratorHelper helper;

    public PropFindXmlGenerator(ValueWriters valueWriters) {
        this.helper = new PropFindXmlGeneratorHelper(valueWriters);
    }

    PropFindXmlGenerator(PropFindXmlGeneratorHelper helper) {
        this.helper = helper;
    }

    public String generate(List<PropFindResponse> propFindResponses) {
        ByteArrayOutputStream responseOutput = new ByteArrayOutputStream();
        Map<String, String> mapOfNamespaces = this.helper.findNameSpaces(propFindResponses);
        ByteArrayOutputStream generatedXml = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)generatedXml);
        writer.writeXMLHeader();
        writer.open(WebDavProtocol.NS_DAV.getPrefix(), "multistatus" + this.helper.generateNamespaceDeclarations(mapOfNamespaces));
        writer.newLine();
        this.helper.appendResponses(writer, propFindResponses, mapOfNamespaces);
        writer.close(WebDavProtocol.NS_DAV.getPrefix(), "multistatus");
        writer.flush();
        if (log.isTraceEnabled()) {
            log.trace("---- PROPFIND response START: " + HttpManager.request().getAbsolutePath() + " -----");
            log.trace(generatedXml.toString());
            log.trace("---- PROPFIND response END -----");
        }
        this.helper.write(generatedXml, (OutputStream)responseOutput);
        try {
            return responseOutput.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

