/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.common.FileUtils;
import io.milton.common.Utils;
import io.milton.event.Event;
import io.milton.event.EventManager;
import io.milton.event.PutEvent;
import io.milton.http.FileItem;
import io.milton.http.HttpManager;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.json.JsonResource;
import io.milton.resource.DeletableResource;
import io.milton.resource.PostableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.ReplaceableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.util.CycleDetectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutJsonResource
extends JsonResource
implements PostableResource {
    private static final Logger log = LoggerFactory.getLogger(PutJsonResource.class);
    public static final String PARAM_AUTONAME = "_autoname";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_OVERWRITE = "overwrite";
    private final EventManager eventManager;
    private final PutableResource wrapped;
    private final String href;
    private List<NewFile> newFiles;

    public PutJsonResource(PutableResource putableResource, String href, EventManager eventManager) {
        super((Resource)putableResource, Request.Method.PUT.code, null);
        this.eventManager = eventManager;
        this.wrapped = putableResource;
        this.href = href;
    }

    @Override
    public String getContentType(String accepts) {
        String s = "text/plain";
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws ConflictException, NotAuthorizedException, BadRequestException {
        log.info("processForm: " + this.wrapped.getClass());
        if (files.isEmpty()) {
            log.debug("no files uploaded");
            return null;
        }
        this.newFiles = new ArrayList<NewFile>();
        for (FileItem file : files.values()) {
            NewFile nf = new NewFile();
            String ua = HttpManager.request().getUserAgentHeader();
            String f = Utils.truncateFileName((String)ua, (String)file.getName());
            nf.setOriginalName(f);
            nf.setContentType(file.getContentType());
            nf.setLength(file.getSize());
            this.newFiles.add(nf);
            String newName = this.getName(f, parameters);
            log.info("creating resource: " + newName + " size: " + file.getSize());
            InputStream in = null;
            try {
                Resource newResource;
                in = file.getInputStream();
                Resource existing = this.wrapped.child(newName);
                if (existing != null) {
                    if (existing instanceof ReplaceableResource) {
                        log.trace("existing resource is replaceable, so replace content");
                        ReplaceableResource rr = (ReplaceableResource)existing;
                        rr.replaceContent(in, null);
                        log.trace("completed POST processing for file. Updated: " + existing.getName());
                        this.eventManager.fireEvent((Event)new PutEvent((Resource)rr));
                        newResource = rr;
                    } else {
                        log.trace("existing resource is not replaceable, will be deleted");
                        if (!(existing instanceof DeletableResource)) throw new BadRequestException(existing, "existing resource could not be deleted, is not deletable");
                        DeletableResource dr = (DeletableResource)existing;
                        dr.delete();
                        newResource = this.wrapped.createNew(newName, in, Long.valueOf(file.getSize()), file.getContentType());
                        log.trace("completed POST processing for file. Deleted, then created: " + newResource.getName());
                        this.eventManager.fireEvent((Event)new PutEvent(newResource));
                    }
                } else {
                    newResource = this.wrapped.createNew(newName, in, Long.valueOf(file.getSize()), file.getContentType());
                    log.info("completed POST processing for file. Created: " + newResource.getName());
                    this.eventManager.fireEvent((Event)new PutEvent(newResource));
                }
                String newHref = this.buildNewHref(this.href, newResource.getName());
                nf.setHref(newHref);
            }
            catch (NotAuthorizedException ex) {
                throw new RuntimeException(ex);
            }
            catch (BadRequestException ex) {
                throw new RuntimeException(ex);
            }
            catch (ConflictException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException("Exception creating resource", ex);
            }
            finally {
                FileUtils.close((InputStream)in);
            }
        }
        log.trace("completed all POST processing");
        return null;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException {
        NewFile[] arr;
        JsonConfig cfg = new JsonConfig();
        cfg.setIgnoreTransientFields(true);
        cfg.setCycleDetectionStrategy(CycleDetectionStrategy.LENIENT);
        if (this.newFiles != null) {
            arr = new NewFile[this.newFiles.size()];
            this.newFiles.toArray(arr);
        } else {
            arr = new NewFile[]{};
        }
        PrintWriter writer = new PrintWriter(out);
        JSON json = JSONSerializer.toJSON((Object)arr, (JsonConfig)cfg);
        json.write((Writer)writer);
        ((Writer)writer).flush();
    }

    @Override
    public Request.Method applicableMethod() {
        return Request.Method.PUT;
    }

    private String getName(String filename, Map<String, String> parameters) throws ConflictException, NotAuthorizedException, BadRequestException {
        boolean overwrite;
        String initialName = filename;
        if (parameters.containsKey(PARAM_NAME)) {
            initialName = parameters.get(PARAM_NAME);
        }
        boolean nonBlankName = initialName != null && initialName.trim().length() > 0;
        boolean autoname = parameters.get(PARAM_AUTONAME) != null;
        boolean bl = overwrite = parameters.get(PARAM_OVERWRITE) != null;
        if (nonBlankName) {
            Resource child = this.wrapped.child(initialName);
            if (child == null) {
                log.trace("no existing file with that name");
                return initialName;
            }
            if (overwrite) {
                log.trace("file exists, and overwrite parameters is set, so allow overwrite: " + initialName);
                return initialName;
            }
            if (!autoname) {
                log.warn("Conflict: Can't create resource with name " + initialName + " because it already exists. To rename automatically use request parameter: " + PARAM_AUTONAME + ", or to overwrite use " + PARAM_OVERWRITE);
                throw new ConflictException((Resource)this);
            }
            log.trace("file exists and autoname is set, so will find acceptable name");
        } else {
            initialName = this.getDateAsName("upload");
            log.trace("no name given in request");
        }
        return this.findAcceptableName(initialName);
    }

    private String getDateAsName(String base) {
        Calendar cal = Calendar.getInstance();
        return base + "_" + cal.get(1) + "-" + cal.get(2) + "-" + cal.get(5);
    }

    private String findAcceptableName(String initialName) throws ConflictException, NotAuthorizedException, BadRequestException {
        String baseName = FileUtils.stripExtension((String)initialName);
        String ext = FileUtils.getExtension((String)initialName);
        return this.findAcceptableName(baseName, ext, 1);
    }

    private String findAcceptableName(String baseName, String ext, int i) throws ConflictException, NotAuthorizedException, BadRequestException {
        String candidateName = baseName + "_" + i;
        if (ext != null && ext.length() > 0) {
            candidateName = candidateName + "." + ext;
        }
        if (this.wrapped.child(candidateName) == null) {
            return candidateName;
        }
        if (i < 100) {
            return this.findAcceptableName(baseName, ext, i + 1);
        }
        log.warn("Too many files with similar names: " + candidateName);
        throw new ConflictException((Resource)this);
    }

    private String buildNewHref(String href, String newName) {
        String s = href;
        int pos = href.lastIndexOf("_DAV");
        if (!(s = s.substring(0, pos - 1)).endsWith("/")) {
            s = s + "/";
        }
        s = s + newName;
        return s;
    }

    public class NewFile {
        private String href;
        private String originalName;
        private long length;
        private String contentType;

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public void setOriginalName(String originalName) {
            this.originalName = originalName;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }
}

