/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.common.LogUtils;
import io.milton.common.Path;
import io.milton.event.EventManager;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.json.AjaxLoginResource;
import io.milton.http.json.CopyJsonResource;
import io.milton.http.json.JsonPropFindHandler;
import io.milton.http.json.JsonPropPatchHandler;
import io.milton.http.json.MkcolJsonResource;
import io.milton.http.json.MoveJsonResource;
import io.milton.http.json.PropFindJsonResource;
import io.milton.http.json.PropPatchJsonResource;
import io.milton.http.json.PutJsonResource;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropPatchSetter;
import io.milton.property.PropertyAuthoriser;
import io.milton.property.PropertySource;
import io.milton.resource.CopyableResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.MoveableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.Resource;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(JsonResourceFactory.class);
    private final ResourceFactory wrapped;
    private final JsonPropFindHandler propFindHandler;
    private final JsonPropPatchHandler propPatchHandler;
    private final EventManager eventManager;
    private Long maxAgeSecsPropFind = null;
    private static final String DAV_FOLDER = "_DAV";
    private List<String> contentTypes = Arrays.asList("application/json", "application/x-javascript");
    private String ajaxLoginPath = "/.login";

    public JsonResourceFactory(ResourceFactory wrapped, EventManager eventManager, JsonPropFindHandler propFindHandler, JsonPropPatchHandler propPatchHandler) {
        this.wrapped = wrapped;
        this.propFindHandler = propFindHandler;
        this.propPatchHandler = propPatchHandler;
        this.eventManager = eventManager;
        log.debug("created with: " + propFindHandler.getClass().getCanonicalName());
    }

    public JsonResourceFactory(ResourceFactory wrapped, EventManager eventManager, List<PropertySource> propertySources, PropPatchSetter patchSetter, PropertyAuthoriser permissionService) {
        this.wrapped = wrapped;
        this.eventManager = eventManager;
        log.debug("using property sources: " + propertySources.size());
        this.propFindHandler = new JsonPropFindHandler(new PropFindPropertyBuilder(propertySources));
        this.propPatchHandler = new JsonPropPatchHandler(patchSetter, permissionService, eventManager);
    }

    public Resource getResource(String host, String sPath) throws NotAuthorizedException, BadRequestException {
        LogUtils.trace((Logger)log, (Object[])new Object[]{"getResource", host, sPath});
        Path path = Path.path((String)sPath);
        Path parent = path.getParent();
        Request request = HttpManager.request();
        String encodedPath = request.getAbsolutePath();
        if (this.isMatchingPath(parent)) {
            log.trace("getResource: is matching path");
            Path resourcePath = parent.getParent();
            if (resourcePath != null) {
                String method = path.getName();
                Resource wrappedResource = this.wrapped.getResource(host, resourcePath.toString());
                if (wrappedResource != null) {
                    Resource r = this.wrapResource(host, wrappedResource, method, encodedPath);
                    LogUtils.trace((Logger)log, (Object[])new Object[]{"returning a", r.getClass()});
                    return r;
                }
            }
        } else {
            if (this.isAjaxLoginPath(sPath)) {
                Resource h = this.wrapped.getResource(host, "/");
                if (h == null) {
                    log.info("Found a login path, but couldnt get a root resource to delegate login to");
                    return null;
                }
                return new AjaxLoginResource(sPath, h);
            }
            log.trace("getResource: not matching path");
            return this.wrapped.getResource(host, sPath);
        }
        return null;
    }

    private boolean isMatchingPath(Path parent) {
        return parent != null && parent.getName() != null && parent.getName().equals(DAV_FOLDER);
    }

    public Resource wrapResource(String host, Resource wrappedResource, String method, String href) {
        LogUtils.trace((Logger)log, (Object[])new Object[]{"wrapResource: ", method});
        if (Request.Method.PROPFIND.code.equals(method)) {
            if (wrappedResource instanceof PropFindableResource) {
                return new PropFindJsonResource((PropFindableResource)wrappedResource, this.propFindHandler, href, this.maxAgeSecsPropFind);
            }
            log.warn("Located a resource for PROPFIND path, but it does not implement PropFindableResource: " + wrappedResource.getClass());
        }
        if (Request.Method.PROPPATCH.code.equals(method)) {
            return new PropPatchJsonResource(wrappedResource, this.propPatchHandler, href);
        }
        if (Request.Method.PUT.code.equals(method) && wrappedResource instanceof PutableResource) {
            return new PutJsonResource((PutableResource)wrappedResource, href, this.eventManager);
        }
        if (Request.Method.MKCOL.code.equals(method) && wrappedResource instanceof MakeCollectionableResource) {
            return new MkcolJsonResource((MakeCollectionableResource)wrappedResource, href, this.eventManager);
        }
        if (Request.Method.COPY.code.equals(method) && wrappedResource instanceof CopyableResource) {
            return new CopyJsonResource(host, (CopyableResource)wrappedResource, this.wrapped);
        }
        if (Request.Method.MOVE.code.equals(method) && wrappedResource instanceof MoveableResource) {
            return new MoveJsonResource(host, (MoveableResource)wrappedResource, this.wrapped);
        }
        return wrappedResource;
    }

    public JsonPropFindHandler getPropFindHandler() {
        return this.propFindHandler;
    }

    public JsonPropPatchHandler getPropPatchHandler() {
        return this.propPatchHandler;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public Long getMaxAgeSecsPropFind() {
        return this.maxAgeSecsPropFind;
    }

    public void setMaxAgeSecsPropFind(Long maxAgeSecsPropFind) {
        this.maxAgeSecsPropFind = maxAgeSecsPropFind;
    }

    private boolean isMatchingContentType(String acceptsHeader) {
        if (acceptsHeader != null) {
            if (this.contentTypes != null) {
                for (String s : this.contentTypes) {
                    if (!acceptsHeader.contains(s)) continue;
                    return true;
                }
            } else {
                log.trace("no configured content types");
            }
        } else {
            log.trace("No accepts header in the request");
        }
        log.trace("isMatchingContentType: not matching type: {}", (Object)acceptsHeader);
        return false;
    }

    public List<String> getContentTypes() {
        return this.contentTypes;
    }

    public void setContentTypes(List<String> contentTypes) {
        this.contentTypes = contentTypes;
    }

    private boolean isAjaxLoginPath(String sPath) {
        return sPath.equals(this.ajaxLoginPath);
    }
}

