/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.common.LogUtils;
import io.milton.event.Event;
import io.milton.event.EventManager;
import io.milton.event.PropPatchEvent;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.webdav.PropFindResponse;
import io.milton.http.webdav.PropPatchRequestParser;
import io.milton.http.webdav.PropPatchSetter;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.property.PropertyAuthoriser;
import io.milton.resource.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPropPatchHandler {
    private static final Logger log = LoggerFactory.getLogger(JsonPropPatchHandler.class);
    private final PropPatchSetter patchSetter;
    private final PropertyAuthoriser permissionService;
    private final EventManager eventManager;

    public JsonPropPatchHandler(PropPatchSetter patchSetter, PropertyAuthoriser permissionService, EventManager eventManager) {
        this.patchSetter = patchSetter;
        this.permissionService = permissionService;
        this.eventManager = eventManager;
    }

    public PropFindResponse process(Resource wrappedResource, String encodedUrl, Map<String, String> params) throws NotAuthorizedException, ConflictException, BadRequestException {
        Set<PropertyAuthoriser.CheckResult> errorFields;
        log.trace("process");
        HashMap<QName, String> fields = new HashMap<QName, String>();
        for (String fieldName : params.keySet()) {
            QName qn;
            String sFieldValue = params.get(fieldName);
            if (fieldName.contains(":")) {
                String[] parts = fieldName.split(":");
                String nsUri = parts[0];
                String localName = parts[1];
                qn = new QName(nsUri, localName);
            } else {
                qn = new QName(WebDavProtocol.NS_DAV.getPrefix(), fieldName);
            }
            log.debug("field: " + qn);
            fields.put(qn, sFieldValue);
        }
        PropPatchRequestParser.ParseResult parseResult = new PropPatchRequestParser.ParseResult(fields, null);
        if (log.isTraceEnabled()) {
            log.trace("check permissions with: " + this.permissionService.getClass());
        }
        if ((errorFields = this.permissionService.checkPermissions(HttpManager.request(), Request.Method.PROPPATCH, PropertyAuthoriser.PropertyPermission.WRITE, fields.keySet(), wrappedResource)) != null && errorFields.size() > 0) {
            log.info("authorisation errors: " + errorFields.size() + " from permissionService: " + this.permissionService.getClass());
            if (log.isTraceEnabled()) {
                for (PropertyAuthoriser.CheckResult e : errorFields) {
                    LogUtils.trace((Logger)log, (Object[])new Object[]{" - field error: ", e.getField(), e.getStatus(), e.getDescription()});
                }
            }
            throw new NotAuthorizedException(wrappedResource);
        }
        LogUtils.trace((Logger)log, (Object[])new Object[]{"setting properties with", this.patchSetter.getClass()});
        PropFindResponse resp = this.patchSetter.setProperties(encodedUrl, parseResult, wrappedResource);
        if (this.eventManager != null) {
            log.trace("fire event");
            this.eventManager.fireEvent((Event)new PropPatchEvent(wrappedResource, resp));
        } else {
            log.trace("no event manager");
        }
        if (resp.getErrorProperties().size() > 0) {
            LogUtils.warn((Logger)log, (Object[])new Object[]{"Encountered errors setting fields with patch setter", this.patchSetter.getClass()});
        }
        if (log.isTraceEnabled() && resp.getErrorProperties().size() > 0) {
            for (List e : resp.getErrorProperties().values()) {
                for (PropFindResponse.NameAndError ne : e) {
                    LogUtils.trace((Logger)log, (Object[])new Object[]{" - field error setting properties: ", ne.getName(), ne.getError()});
                }
            }
        }
        return resp;
    }

    public PropertyAuthoriser getPermissionService() {
        return this.permissionService;
    }
}

