/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.http.Request;
import io.milton.http.http11.auth.ExpiredNonceRemover;
import io.milton.http.http11.auth.Nonce;
import io.milton.http.http11.auth.NonceProvider;
import io.milton.resource.Resource;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMemoryNonceProvider
implements NonceProvider {
    private static final Logger log = LoggerFactory.getLogger(SimpleMemoryNonceProvider.class);
    private final int nonceValiditySeconds;
    private Map<UUID, Nonce> nonces;
    private final ExpiredNonceRemover remover;
    private boolean enableNonceCountChecking;

    public SimpleMemoryNonceProvider(int nonceValiditySeconds, ExpiredNonceRemover remover, Map<UUID, Nonce> nonces) {
        if (log.isTraceEnabled()) {
            log.trace("Created SimpleMemoryNonceProvider(b): nonceValiditySeconds: " + nonceValiditySeconds);
        }
        this.nonces = nonces;
        this.nonceValiditySeconds = nonceValiditySeconds;
        this.remover = remover;
    }

    public SimpleMemoryNonceProvider(int nonceValiditySeconds) {
        if (log.isTraceEnabled()) {
            log.trace("Created SimpleMemoryNonceProvider(b): nonceValiditySeconds: " + nonceValiditySeconds);
        }
        this.nonces = new ConcurrentHashMap<UUID, Nonce>();
        this.nonceValiditySeconds = nonceValiditySeconds;
        this.remover = new ExpiredNonceRemover(this.nonces, nonceValiditySeconds);
    }

    public Nonce createNonceObject(Resource resource, Request request) {
        UUID id = UUID.randomUUID();
        Date now = new Date();
        Nonce n = new Nonce(id, now);
        this.nonces.put(n.getValue(), n);
        return n;
    }

    @Override
    public String createNonce(Resource resource, Request request) {
        String n = this.createNonceObject(resource, request).getValue().toString();
        if (log.isTraceEnabled()) {
            log.trace("Created nonce: " + n + " in map of size: " + this.nonces.size());
        }
        return n;
    }

    @Override
    public NonceProvider.NonceValidity getNonceValidity(String nonce, Long nc) {
        if (log.isTraceEnabled()) {
            log.trace("getNonceValidity: " + nonce);
        }
        UUID value = null;
        try {
            value = UUID.fromString(nonce);
        }
        catch (Exception e) {
            log.warn("couldnt parse nonce");
            return NonceProvider.NonceValidity.INVALID;
        }
        Nonce n = this.nonces.get(value);
        if (n == null) {
            log.debug("not found in map of size: " + this.nonces.size());
            return NonceProvider.NonceValidity.INVALID;
        }
        if (this.isExpired(n.getIssued())) {
            log.debug("nonce has expired");
            return NonceProvider.NonceValidity.EXPIRED;
        }
        if (nc == null) {
            log.trace("nonce ok");
            return NonceProvider.NonceValidity.OK;
        }
        if (this.enableNonceCountChecking && nc <= n.getNonceCount()) {
            log.warn("nonce-count was not greater then previous, possible replay attack. new: " + nc + " old:" + n.getNonceCount());
            return NonceProvider.NonceValidity.INVALID;
        }
        log.trace("nonce and nonce-count ok");
        Nonce newNonce = n.increaseNonceCount(nc);
        this.nonces.put(newNonce.getValue(), newNonce);
        return NonceProvider.NonceValidity.OK;
    }

    private boolean isExpired(Date issued) {
        long dif = (System.currentTimeMillis() - issued.getTime()) / 1000L;
        return dif > (long)this.nonceValiditySeconds;
    }

    public boolean isEnableNonceCountChecking() {
        return this.enableNonceCountChecking;
    }

    public void setEnableNonceCountChecking(boolean enableNonceCountChecking) {
        this.enableNonceCountChecking = enableNonceCountChecking;
    }
}

