/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.http.AuthenticationHandler;
import io.milton.http.Request;
import io.milton.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormAuthenticationHandler
implements AuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(FormAuthenticationHandler.class);
    private String userNameParam = "_loginUserName";
    private String passwordParam = "_loginPassword";
    private String loginResultAttName = "loginResult";

    @Override
    public boolean supports(Resource r, Request request) {
        boolean b = this.isLogin(request);
        if (log.isTraceEnabled()) {
            log.trace("supports: " + b);
        }
        return b;
    }

    @Override
    public Object authenticate(Resource resource, Request request) {
        String pwd;
        String userName = (String)request.getParams().get(this.userNameParam);
        Object o = resource.authenticate(userName, pwd = (String)request.getParams().get(this.passwordParam));
        if (o == null) {
            request.getAttributes().put("loginResult", Boolean.FALSE);
        } else {
            request.getAttributes().put("loginResult", Boolean.TRUE);
        }
        return o;
    }

    @Override
    public String getChallenge(Resource resource, Request request) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCompatible(Resource resource, Request request) {
        return false;
    }

    private boolean isLogin(Request request) {
        return request.getMethod() == Request.Method.POST && request.getParams().get(this.userNameParam) != null;
    }

    public String getUserNameParam() {
        return this.userNameParam;
    }

    public void setUserNameParam(String userNameParam) {
        this.userNameParam = userNameParam;
    }

    public String getPasswordParam() {
        return this.passwordParam;
    }

    public void setPasswordParam(String passwordParam) {
        this.passwordParam = passwordParam;
    }

    public String getLoginResultAttName() {
        return this.loginResultAttName;
    }

    public void setLoginResultAttName(String loginResultAttName) {
        this.loginResultAttName = loginResultAttName;
    }
}

