/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.http.http11.auth.DigestResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestGenerator {
    private static final Logger log = LoggerFactory.getLogger(DigestGenerator.class);

    public String generateDigest(DigestResponse dr, String password) throws IllegalArgumentException {
        log.debug("user:" + dr.getUser() + ":realm:" + dr.getRealm() + ":" + password);
        String p = password == null ? "" : password;
        String a1Md5 = this.encodePasswordInA1Format(dr.getUser(), dr.getRealm(), p);
        return this.generateDigestWithEncryptedPassword(dr, a1Md5);
    }

    public String generateDigestWithEncryptedPassword(DigestResponse dr, String a1Md5) throws IllegalArgumentException {
        String httpMethod = dr.getMethod().code;
        String a2Md5 = this.encodeMethodAndUri(httpMethod, dr.getUri());
        String qop = dr.getQop();
        String nonce = dr.getNonce();
        if (qop == null) {
            return this.md5(a1Md5, dr.getNonce(), a2Md5);
        }
        if ("auth".equals(qop)) {
            return this.md5(a1Md5, nonce, dr.getNc(), dr.getCnonce(), dr.getQop(), a2Md5);
        }
        throw new IllegalArgumentException("This method does not support a qop '" + qop + "'");
    }

    public String encodePasswordInA1Format(String username, String realm, String password) {
        String a1 = username + ":" + realm + ":" + password;
        String a1Md5 = new String(DigestUtils.md5Hex((String)a1));
        return a1Md5;
    }

    String encodeMethodAndUri(String httpMethod, String uri) {
        String a2 = httpMethod + ":" + uri;
        String a2Md5 = new String(DigestUtils.md5Hex((String)a2));
        return a2Md5;
    }

    public String md5(String ... ss) {
        String d = "";
        for (int i = 0; i < ss.length; ++i) {
            if (i > 0) {
                d = d + ":";
            }
            d = d + ss[i];
        }
        return new String(DigestUtils.md5Hex((String)d));
    }
}

