/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.http.AuthenticationHandler;
import io.milton.http.Cookie;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.principal.DiscretePrincipal;
import io.milton.resource.Resource;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieAuthenticationHandler
implements AuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(CookieAuthenticationHandler.class);
    private static final String HANDLER_ATT_NAME = "_delegatedAuthenticationHandler";
    private String requestParamLogout = "miltonLogout";
    private String cookieUserUrlValue = "miltonUserUrl";
    private String cookieUserUrlHash = "miltonUserUrlHash";
    private final List<AuthenticationHandler> handlers;
    private final ResourceFactory principalResourceFactory;
    private String userUrlAttName = "userUrl";

    public CookieAuthenticationHandler(List<AuthenticationHandler> handlers, ResourceFactory principalResourceFactory) {
        this.handlers = handlers;
        this.principalResourceFactory = principalResourceFactory;
    }

    @Override
    public boolean supports(Resource r, Request request) {
        String userUrl = this.getUserUrl(request);
        if (this.isLogout(request) && userUrl != null && userUrl.length() > 0) {
            this.clearCookieValue(HttpManager.response());
        }
        for (AuthenticationHandler hnd : this.handlers) {
            if (!hnd.supports(r, request)) continue;
            request.getAttributes().put(HANDLER_ATT_NAME, hnd);
            return true;
        }
        return userUrl != null;
    }

    @Override
    public Object authenticate(Resource resource, Request request) {
        Resource r;
        log.trace("authenticate");
        AuthenticationHandler delegateHandler = (AuthenticationHandler)request.getAttributes().get(HANDLER_ATT_NAME);
        if (delegateHandler != null) {
            Object tag = delegateHandler.authenticate(resource, request);
            if (tag != null) {
                if (tag instanceof DiscretePrincipal) {
                    DiscretePrincipal p = (DiscretePrincipal)tag;
                    this.setLoginCookies(p, request);
                    log.trace("authentication passed by delegated handler, persisted userUrl to cookie");
                } else {
                    log.warn("auth.tag is not a " + DiscretePrincipal.class + ", is: " + tag);
                }
                return tag;
            }
            log.info("Login failed by delegated handler: " + delegateHandler.getClass());
            return null;
        }
        if (this.isLogout(request)) {
            return null;
        }
        String userUrl = this.getUserUrl(request);
        if (userUrl == null) {
            return null;
        }
        String host = request.getHostHeader();
        try {
            r = this.principalResourceFactory.getResource(host, userUrl);
        }
        catch (NotAuthorizedException ex) {
            log.error("Couldnt check userUrl in cookie", (Throwable)ex);
            r = null;
        }
        catch (BadRequestException ex) {
            log.error("Couldnt check userUrl in cookie", (Throwable)ex);
            r = null;
        }
        if (r == null) {
            log.warn("User not found host: " + host + " userUrl: " + userUrl + " with resourcefactory: " + this.principalResourceFactory);
            this.clearCookieValue(HttpManager.response());
        } else if (r instanceof DiscretePrincipal) {
            DiscretePrincipal dp = (DiscretePrincipal)r;
            this.setLoginCookies(dp, request);
        } else {
            log.warn("Found user from request, but user object is not expected type. Should be " + DiscretePrincipal.class + " but is " + r.getClass());
        }
        return r;
    }

    public void setLoginCookies(DiscretePrincipal user, Request request) {
        String userUrl = user.getIdenitifer().getValue();
        this.setLoginCookies(userUrl, request);
    }

    public void setLoginCookies(String userUrl, Request request) {
        if (request == null) {
            return;
        }
        Response response = HttpManager.response();
        String signing = this.getUrlSigningHash(userUrl);
        this.setCookieValues(response, userUrl, signing);
        request.getAttributes().put(this.userUrlAttName, userUrl);
    }

    public String getUrlSigningHash(String userUrl) {
        String salt = Math.random() + "";
        String signing = salt + ":" + DigestUtils.md5Hex((String)(userUrl + ":" + salt));
        return signing;
    }

    @Override
    public String getChallenge(Resource resource, Request request) {
        for (AuthenticationHandler h : this.handlers) {
            if (!h.isCompatible(resource, request)) continue;
            return h.getChallenge(resource, request);
        }
        throw new UnsupportedOperationException("Not supported because no delegate handler accepted the request");
    }

    @Override
    public boolean isCompatible(Resource resource, Request request) {
        for (AuthenticationHandler h : this.handlers) {
            if (!h.isCompatible(resource, request)) continue;
            return true;
        }
        return false;
    }

    private boolean isLogout(Request request) {
        if (request.getParams() == null) {
            return false;
        }
        String logoutCommand = (String)request.getParams().get(this.requestParamLogout);
        return logoutCommand != null && logoutCommand.length() > 0;
    }

    private String getUserUrl(Request request) {
        if (request == null) {
            return null;
        }
        String userUrl = this.getUserUrlFromRequest(request);
        if (userUrl != null && (userUrl = userUrl.trim()).length() > 0) {
            if (this.verifyHash(userUrl, request)) {
                return userUrl;
            }
            log.error("Invalid userUrl hash, possible attempted hacking attempt");
        }
        return null;
    }

    public String getUserUrlFromRequest(Request request) {
        return this.getCookieOrParam(request, this.cookieUserUrlValue);
    }

    public String getHashFromRequest(Request request) {
        String signing = this.getCookieOrParam(request, this.cookieUserUrlHash);
        return signing;
    }

    private boolean verifyHash(String userUrl, Request request) {
        String signing = this.getHashFromRequest(request);
        if (signing == null) {
            return false;
        }
        if ((signing = signing.trim()).length() == 0) {
            return false;
        }
        String[] arr = signing.split(":");
        if (arr.length != 2) {
            return false;
        }
        String salt = arr[0];
        String hash = arr[1];
        String expectedHash = DigestUtils.md5Hex((String)(userUrl + ":" + salt));
        return expectedHash.equals(hash);
    }

    private void setCookieValues(Response response, String userUrl, String hash) {
        response.setCookie(this.cookieUserUrlValue, userUrl);
        response.setCookie(this.cookieUserUrlHash, hash);
    }

    private void clearCookieValue(Response response) {
        response.setCookie(this.cookieUserUrlValue, "");
        response.setCookie(this.cookieUserUrlHash, "");
    }

    private String getCookieOrParam(Request request, String name) {
        String v;
        if (request == null) {
            return null;
        }
        if (request.getParams() != null && (v = (String)request.getParams().get(name)) != null) {
            return v;
        }
        Cookie c = request.getCookie(name);
        if (c != null) {
            return c.getValue();
        }
        return null;
    }

    public String getCookieNameUserUrlHash() {
        return this.cookieUserUrlHash;
    }

    public String getCookieNameUserUrl() {
        return this.cookieUserUrlValue;
    }

    public String getUserUrlAttName() {
        return this.userUrlAttName;
    }

    public void setUserUrlAttName(String userUrlAttName) {
        this.userUrlAttName = userUrlAttName;
    }
}

