/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.common.StreamUtils;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.entity.PartialEntity;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.resource.GetableResource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialGetHelper {
    private static final Logger log = LoggerFactory.getLogger(PartialGetHelper.class);
    private final Http11ResponseHandler responseHandler;
    private int maxMemorySize = 100000;

    public PartialGetHelper(Http11ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    public List<Range> getRanges(String rangeHeader) {
        if (rangeHeader == null || rangeHeader.length() == 0) {
            log.trace("getRanges: no range header");
            return null;
        }
        if (rangeHeader.startsWith("bytes=")) {
            rangeHeader = rangeHeader.substring(6);
            String[] arr = rangeHeader.split(",");
            ArrayList<Range> list = new ArrayList<Range>();
            for (String s : arr) {
                Range r = Range.parse((String)s);
                list.add(r);
            }
            if (log.isTraceEnabled()) {
                log.trace("getRanges: header: " + rangeHeader + " parsed ranges: " + list.size());
            }
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPartialContent(GetableResource resource, Request request, Response response, List<Range> ranges, Map<String, String> params) throws NotAuthorizedException, BadRequestException, IOException, NotFoundException {
        block3: {
            block2: {
                log.trace("sendPartialContent");
                if (ranges.size() != 1) break block2;
                log.trace("partial get, single range");
                Range r = ranges.get(0);
                this.responseHandler.respondPartialContent(resource, response, request, params, r);
                break block3;
            }
            log.trace("partial get, multiple ranges");
            File temp = File.createTempFile("milton_partial_get", null);
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(temp);
                BufferedOutputStream bufOut = new BufferedOutputStream(fout);
                resource.sendContent((OutputStream)bufOut, null, params, request.getContentTypeHeader());
                bufOut.flush();
                fout.flush();
            }
            catch (Throwable throwable) {
                StreamUtils.close(fout);
                throw throwable;
            }
            StreamUtils.close((OutputStream)fout);
            response.setEntity((Response.Entity)new PartialEntity(ranges, temp));
        }
    }

    public int getMaxMemorySize() {
        return this.maxMemorySize;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }
}

