/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.http.Request;
import io.milton.http.http11.ETagGenerator;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.List;

public class MatchHelper {
    private final ETagGenerator eTagGenerator;

    public MatchHelper(ETagGenerator eTagGenerator) {
        this.eTagGenerator = eTagGenerator;
    }

    public boolean checkIfMatch(Resource r, Request req) {
        String h = req.getIfMatchHeader();
        if (h == null || h.length() == 0) {
            return true;
        }
        if (r == null) {
            System.out.println("checkIfMatch: resource is null");
            return false;
        }
        String currentEtag = this.eTagGenerator.generateEtag(r);
        if (currentEtag == null || currentEtag.length() == 0) {
            System.out.println("checkIfMatch: no etag");
            return false;
        }
        List<String> etags = this.splitToList(h);
        for (String requestedEtag : etags) {
            requestedEtag = this.cleanUp(requestedEtag);
            System.out.println("checkIfMatch: compare: " + requestedEtag + " = " + currentEtag);
            if (!requestedEtag.equals(currentEtag) && !requestedEtag.equals("*")) continue;
            return true;
        }
        System.out.println("checkIfMatch: did not find matching etag");
        return false;
    }

    public boolean checkIfNoneMatch(Resource r, Request req) {
        String h = req.getIfNoneMatchHeader();
        if (h == null) {
            return false;
        }
        if (h.equals("*")) {
            boolean b;
            boolean bl = b = r != null;
            if (b) {
                System.out.println("if-none-match header is star, and a resource exists");
            }
            return b;
        }
        String currentEtag = this.eTagGenerator.generateEtag(r);
        if (currentEtag == null) {
            return false;
        }
        List<String> etags = this.splitToList(h);
        for (String requestedEtag : etags) {
            if (!requestedEtag.equals(currentEtag)) continue;
            System.out.println("found existing etag: " + currentEtag);
            return true;
        }
        return false;
    }

    public boolean checkIfRange(Resource r, Request request) {
        String requestedEtag = request.getIfRangeHeader();
        if (requestedEtag == null || requestedEtag.trim().length() == 0) {
            return true;
        }
        String currentEtag = this.eTagGenerator.generateEtag(r);
        if (currentEtag == null || currentEtag.length() == 0) {
            return false;
        }
        return requestedEtag.equals(currentEtag) || requestedEtag.equals("*");
    }

    private List<String> splitToList(String s) {
        String[] arr = s.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String part : arr) {
            if ((part = part.trim()).length() <= 0) continue;
            list.add(part.trim());
        }
        return list;
    }

    private String cleanUp(String s) {
        s = s.replace("&quot;", "");
        s = s.replace("\"\"", "\"");
        return s;
    }
}

