/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.http.Auth;
import io.milton.http.AuthenticationService;
import io.milton.http.ExternalIdentityProvider;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.entity.BufferingGetableResourceEntity;
import io.milton.http.entity.GetableResourceEntity;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.Bufferable;
import io.milton.http.http11.CacheControlHelper;
import io.milton.http.http11.ContentGenerator;
import io.milton.http.http11.DefaultCacheControlHelper;
import io.milton.http.http11.ETagGenerator;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.http11.SimpleContentGenerator;
import io.milton.resource.BufferingControlResource;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttp11ResponseHandler
implements Http11ResponseHandler,
Bufferable {
    private static String miltonVerson;
    private static final Logger log;
    private final AuthenticationService authenticationService;
    private final ETagGenerator eTagGenerator;
    private CacheControlHelper cacheControlHelper;
    private ContentGenerator contentGenerator;
    private int maxMemorySize;
    private BUFFERING buffering;

    public DefaultHttp11ResponseHandler(AuthenticationService authenticationService, ETagGenerator eTagGenerator) {
        Properties props = new Properties();
        try {
            props.load(DefaultHttp11ResponseHandler.class.getResourceAsStream("/milton.properties"));
        }
        catch (IOException ex) {
            log.warn("Failed lot load milton properties file", (Throwable)ex);
        }
        miltonVerson = props.getProperty("milton.version");
        this.cacheControlHelper = new DefaultCacheControlHelper();
        this.contentGenerator = new SimpleContentGenerator();
        this.maxMemorySize = 100000;
        this.authenticationService = authenticationService;
        this.eTagGenerator = eTagGenerator;
    }

    public CacheControlHelper getCacheControlHelper() {
        return this.cacheControlHelper;
    }

    public void setCacheControlHelper(CacheControlHelper cacheControlHelper) {
        this.cacheControlHelper = cacheControlHelper;
    }

    @Override
    public String generateEtag(Resource r) {
        return this.eTagGenerator.generateEtag(r);
    }

    @Override
    public void respondWithOptions(Resource resource, Response response, Request request, List<String> methodsAllowed) {
        this.setRespondCommonHeaders(response, resource, Response.Status.SC_OK, request.getAuthorization());
        response.setAllowHeader(methodsAllowed);
        response.setContentLengthHeader(Long.valueOf(0L));
    }

    @Override
    public void respondNotFound(Response response, Request request) {
        response.setStatus(Response.Status.SC_NOT_FOUND);
        response.setContentTypeHeader("text/html");
        this.contentGenerator.generate(null, request, response, Response.Status.SC_NOT_FOUND);
    }

    @Override
    public void respondUnauthorised(Resource resource, Response response, Request request) {
        if (this.authenticationService.canUseExternalAuth(resource, request)) {
            log.info("respondUnauthorised: use external authentication");
            this.initiateExternalAuth(resource, request, response);
        } else {
            log.info("respondUnauthorised: return staus: " + Response.Status.SC_UNAUTHORIZED);
            response.setStatus(Response.Status.SC_UNAUTHORIZED);
            List<String> challenges = this.authenticationService.getChallenges(resource, request);
            response.setAuthenticateHeader(challenges);
        }
    }

    @Override
    public void respondMethodNotImplemented(Resource resource, Response response, Request request) {
        response.setStatus(Response.Status.SC_NOT_IMPLEMENTED);
        this.contentGenerator.generate(resource, request, response, Response.Status.SC_NOT_IMPLEMENTED);
    }

    @Override
    public void respondMethodNotAllowed(Resource res, Response response, Request request) {
        log.debug("method not allowed. handler: " + this.getClass().getName() + " resource: " + res.getClass().getName());
        response.setStatus(Response.Status.SC_METHOD_NOT_ALLOWED);
        this.contentGenerator.generate(res, request, response, Response.Status.SC_METHOD_NOT_ALLOWED);
    }

    @Override
    public void respondConflict(Resource resource, Response response, Request request, String message) {
        log.debug("respondConflict");
        response.setStatus(Response.Status.SC_CONFLICT);
        this.contentGenerator.generate(resource, request, response, Response.Status.SC_CONFLICT);
    }

    @Override
    public void respondServerError(Request request, Response response, String reason) {
        response.setStatus(Response.Status.SC_INTERNAL_SERVER_ERROR);
        this.contentGenerator.generate(null, request, response, Response.Status.SC_INTERNAL_SERVER_ERROR);
    }

    @Override
    public void respondRedirect(Response response, Request request, String redirectUrl) {
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl cannot be null");
        }
        log.trace("respondRedirect");
        response.sendRedirect(redirectUrl);
    }

    @Override
    public void respondExpectationFailed(Response response, Request request) {
        response.setStatus(Response.Status.SC_EXPECTATION_FAILED);
    }

    @Override
    public void respondCreated(Resource resource, Response response, Request request) {
        this.setRespondCommonHeaders(response, resource, Response.Status.SC_CREATED, request.getAuthorization());
    }

    @Override
    public void respondNoContent(Resource resource, Response response, Request request) {
        this.setRespondCommonHeaders(response, resource, Response.Status.SC_NO_CONTENT, request.getAuthorization());
    }

    @Override
    public void respondPartialContent(GetableResource resource, Response response, Request request, Map<String, String> params, Range range) throws NotAuthorizedException, BadRequestException, NotFoundException {
        String acc;
        String ct;
        long fn;
        log.debug("respondPartialContent: " + range.getStart() + " - " + range.getFinish());
        response.setStatus(Response.Status.SC_PARTIAL_CONTENT);
        long st = range.getStart() == null ? 0L : range.getStart();
        Long cl = resource.getContentLength();
        if (range.getFinish() == null) {
            if (cl != null) {
                fn = cl - 1L;
            } else {
                log.warn("Couldnt calculate range end position because the resource is not reporting a content length, and no end position was requested by the client: " + resource.getName() + " - " + resource.getClass());
                fn = -1L;
            }
        } else {
            fn = range.getFinish();
        }
        response.setContentRangeHeader(st, fn, cl);
        long contentLength = fn - st + 1L;
        response.setDateHeader(new Date());
        String etag = this.eTagGenerator.generateEtag((Resource)resource);
        if (etag != null) {
            response.setEtag(etag);
        }
        if ((ct = resource.getContentType(acc = request.getAcceptHeader())) != null) {
            response.setContentTypeHeader(ct);
        }
        response.setContentLengthHeader(Long.valueOf(contentLength));
        response.setEntity((Response.Entity)new GetableResourceEntity(resource, range, params, ct));
    }

    @Override
    public void respondHead(Resource resource, Response response, Request request) {
        Long contentLength;
        this.setRespondContentCommonHeaders(response, resource, Response.Status.SC_OK, request.getAuthorization());
        if (!(resource instanceof GetableResource)) {
            return;
        }
        GetableResource gr = (GetableResource)resource;
        String acc = request.getAcceptHeader();
        String ct = gr.getContentType(acc);
        if (ct != null && (ct = this.pickBestContentType(ct)) != null) {
            response.setContentTypeHeader(ct);
        }
        if ((contentLength = gr.getContentLength()) != null) {
            response.setContentLengthHeader(contentLength);
        } else {
            log.trace("No content length is available for HEAD request");
        }
    }

    @Override
    public void respondContent(Resource resource, Response response, Request request, Map<String, String> params) throws NotAuthorizedException, BadRequestException, NotFoundException {
        log.debug("respondContent: " + resource.getClass());
        Auth auth = request.getAuthorization();
        this.setRespondContentCommonHeaders(response, resource, auth);
        if (resource instanceof GetableResource) {
            GetableResource gr = (GetableResource)resource;
            String acc = request.getAcceptHeader();
            String ct = gr.getContentType(acc);
            if (ct != null) {
                ct = this.pickBestContentType(ct);
                response.setContentTypeHeader(ct);
            }
            this.cacheControlHelper.setCacheControl(gr, response, request.getAuthorization());
            Long contentLength = gr.getContentLength();
            Boolean doBuffering = null;
            if (resource instanceof BufferingControlResource) {
                BufferingControlResource bcr = (BufferingControlResource)resource;
                doBuffering = bcr.isBufferingRequired();
            }
            if (doBuffering == null) {
                doBuffering = this.buffering == null || this.buffering == BUFFERING.whenNeeded ? Boolean.valueOf(contentLength == null) : Boolean.valueOf(this.buffering == BUFFERING.always);
            }
            if (!doBuffering.booleanValue()) {
                log.trace("sending content with known content length: " + contentLength);
                if (contentLength != null) {
                    response.setContentLengthHeader(contentLength);
                }
                response.setEntity((Response.Entity)new GetableResourceEntity(gr, params, ct));
            } else {
                BufferingGetableResourceEntity e = new BufferingGetableResourceEntity(gr, params, ct, contentLength, this.getMaxMemorySize());
                response.setEntity((Response.Entity)e);
            }
        }
    }

    @Override
    public void respondNotModified(GetableResource resource, Response response, Request request) {
        log.trace("respondNotModified");
        response.setStatus(Response.Status.SC_NOT_MODIFIED);
        response.setDateHeader(new Date());
        String etag = this.eTagGenerator.generateEtag((Resource)resource);
        if (etag != null) {
            response.setEtag(etag);
        }
        Date modDate = resource.getModifiedDate();
        response.setLastModifiedHeader(modDate);
        this.cacheControlHelper.setCacheControl(resource, response, request.getAuthorization());
    }

    protected void setRespondContentCommonHeaders(Response response, Resource resource, Auth auth) {
        this.setRespondContentCommonHeaders(response, resource, Response.Status.SC_OK, auth);
    }

    protected void setRespondContentCommonHeaders(Response response, Resource resource, Response.Status status, Auth auth) {
        this.setRespondCommonHeaders(response, resource, status, auth);
        DefaultHttp11ResponseHandler.setModifiedDate(response, resource, auth);
    }

    protected void setRespondCommonHeaders(Response response, Resource resource, Response.Status status, Auth auth) {
        response.setStatus(status);
        response.setNonStandardHeader("Server", "milton.io-" + miltonVerson);
        response.setDateHeader(new Date());
        response.setNonStandardHeader("Accept-Ranges", "bytes");
        String etag = this.eTagGenerator.generateEtag(resource);
        if (etag != null) {
            response.setEtag(etag);
        }
    }

    public static void setModifiedDate(Response response, Resource resource, Auth auth) {
        Date modDate = resource.getModifiedDate();
        if (modDate != null) {
            response.setLastModifiedHeader(modDate);
        }
    }

    @Override
    public void respondBadRequest(Resource resource, Response response, Request request) {
        response.setStatus(Response.Status.SC_BAD_REQUEST);
    }

    @Override
    public void respondForbidden(Resource resource, Response response, Request request) {
        response.setStatus(Response.Status.SC_FORBIDDEN);
    }

    @Override
    public void respondDeleteFailed(Request request, Response response, Resource resource, Response.Status status) {
        response.setStatus(status);
    }

    @Override
    public void respondPreconditionFailed(Request request, Response response, Resource resource) {
        response.setStatus(Response.Status.SC_PRECONDITION_FAILED);
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public int getMaxMemorySize() {
        return this.maxMemorySize;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    @Override
    public BUFFERING getBuffering() {
        return this.buffering;
    }

    @Override
    public void setBuffering(BUFFERING buffering) {
        this.buffering = buffering;
    }

    private String pickBestContentType(String ct) {
        if (ct == null) {
            return null;
        }
        if (ct.contains(",")) {
            return ct.split(",")[0];
        }
        return ct;
    }

    public void initiateExternalAuth(Resource resource, Request request, Response response) {
        ExternalIdentityProvider eip = this.getSelectedIP(request);
        if (eip != null) {
            eip.initiateExternalAuth(resource, request, response);
        }
    }

    private ExternalIdentityProvider getSelectedIP(Request request) {
        List<ExternalIdentityProvider> list = this.authenticationService.getExternalIdentityProviders();
        if (list.size() == 1) {
            return list.get(0);
        }
        String ipName = (String)request.getParams().get("_ip");
        if (ipName != null && ipName.length() > 0) {
            for (ExternalIdentityProvider eip : list) {
                if (!ipName.equals(eip.getName())) continue;
                return eip;
            }
        }
        return null;
    }

    public ContentGenerator getContentGenerator() {
        return this.contentGenerator;
    }

    public void setContentGenerator(ContentGenerator contentGenerator) {
        this.contentGenerator = contentGenerator;
    }

    static {
        log = LoggerFactory.getLogger(DefaultHttp11ResponseHandler.class);
    }

    public static enum BUFFERING {
        always,
        never,
        whenNeeded;

    }
}

