/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fs;

import io.milton.http.LockInfo;
import io.milton.http.LockManager;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.LockableResource;
import io.milton.resource.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLockManager
implements LockManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleLockManager.class);
    Map<String, CurrentLock> locksByUniqueId = new HashMap<String, CurrentLock>();
    Map<String, CurrentLock> locksByToken = new HashMap<String, CurrentLock>();

    public synchronized LockResult lock(LockTimeout timeout, LockInfo lockInfo, LockableResource r) {
        LockToken currentLock = this.currentLock(r);
        if (currentLock != null) {
            return LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.ALREADY_LOCKED);
        }
        LockToken newToken = new LockToken(UUID.randomUUID().toString(), lockInfo, timeout);
        CurrentLock newLock = new CurrentLock(r.getUniqueId(), newToken, lockInfo.lockedByUser);
        this.locksByUniqueId.put(r.getUniqueId(), newLock);
        this.locksByToken.put(newToken.tokenId, newLock);
        return LockResult.success((LockToken)newToken);
    }

    public synchronized LockResult refresh(String tokenId, LockableResource resource) {
        CurrentLock curLock = this.locksByToken.get(tokenId);
        curLock.token.setFrom(new Date());
        return LockResult.success((LockToken)curLock.token);
    }

    public synchronized void unlock(String tokenId, LockableResource r) throws NotAuthorizedException {
        LockToken lockToken = this.currentLock(r);
        if (lockToken == null) {
            log.debug("not locked");
            return;
        }
        if (!lockToken.tokenId.equals(tokenId)) {
            throw new NotAuthorizedException((Resource)r);
        }
        this.removeLock(lockToken);
    }

    private LockToken currentLock(LockableResource resource) {
        CurrentLock curLock = this.locksByUniqueId.get(resource.getUniqueId());
        if (curLock == null) {
            return null;
        }
        LockToken token = curLock.token;
        if (token.isExpired()) {
            this.removeLock(token);
            return null;
        }
        return token;
    }

    private void removeLock(LockToken token) {
        log.debug("removeLock: " + token.tokenId);
        CurrentLock currentLock = this.locksByToken.get(token.tokenId);
        if (currentLock != null) {
            this.locksByUniqueId.remove(currentLock.id);
            this.locksByToken.remove(currentLock.token.tokenId);
        } else {
            log.warn("couldnt find lock: " + token.tokenId);
        }
    }

    public LockToken getCurrentToken(LockableResource r) {
        CurrentLock lock = this.locksByUniqueId.get(r.getUniqueId());
        if (lock == null) {
            return null;
        }
        LockToken token = new LockToken();
        token.info = new LockInfo(LockInfo.LockScope.EXCLUSIVE, LockInfo.LockType.WRITE, lock.lockedByUser, LockInfo.LockDepth.ZERO);
        token.info.lockedByUser = lock.lockedByUser;
        token.timeout = lock.token.timeout;
        token.tokenId = lock.token.tokenId;
        return token;
    }

    class CurrentLock {
        final String id;
        final LockToken token;
        final String lockedByUser;

        public CurrentLock(String id, LockToken token, String lockedByUser) {
            this.id = id;
            this.token = token;
            this.lockedByUser = lockedByUser;
        }
    }
}

