/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fs;

import io.milton.common.ContentTypeUtils;
import io.milton.common.Path;
import io.milton.http.Auth;
import io.milton.http.FileItem;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.SecurityManager;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.resource.DigestResource;
import io.milton.resource.GetableResource;
import io.milton.resource.PostableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(ClassPathResourceFactory.class);
    private String basePath;
    private Long maxAgeSeconds = 604800L;
    private SecurityManager securityManager;
    private Date modifiedDate = new Date();

    public Resource getResource(String host, String path) {
        InputStream content;
        Path p = Path.path((String)path);
        if (this.basePath != null) {
            if (p.getFirst().equals(this.basePath)) {
                p = p.getStripFirst();
            } else {
                return null;
            }
        }
        if ((content = this.getClass().getResourceAsStream(p.toString())) == null) {
            return null;
        }
        log.trace("return class path resource");
        return new ClassPathResource(host, p, content);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public Long getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public void setMaxAgeSeconds(Long maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public class ClassPathResource
    implements GetableResource,
    DigestResource,
    PostableResource {
        private final String host;
        private final Path path;
        private final InputStream content;

        public ClassPathResource(String host, Path path, InputStream content) {
            this.host = host;
            this.path = path;
            this.content = content;
            if (content == null) {
                throw new IllegalArgumentException("content cannot be null");
            }
        }

        public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
            try {
                IOUtils.copy((InputStream)this.content, (OutputStream)out);
            }
            catch (NullPointerException npe) {
                log.debug("NullPointerException, this is often expected");
            }
        }

        public Long getMaxAgeSeconds(Auth auth) {
            return ClassPathResourceFactory.this.maxAgeSeconds;
        }

        public String getContentType(String preferredList) {
            String mime = ContentTypeUtils.findContentTypes((String)this.path.getName());
            String s = ContentTypeUtils.findAcceptableContentType((String)mime, (String)preferredList);
            if (log.isTraceEnabled()) {
                log.trace("getContentType: preferred: {} mime: {} selected: {}", new Object[]{preferredList, mime, s});
            }
            return s;
        }

        public Long getContentLength() {
            return null;
        }

        public String getUniqueId() {
            return null;
        }

        public String getName() {
            return this.path.getName();
        }

        public Object authenticate(String user, String password) {
            if (ClassPathResourceFactory.this.securityManager != null) {
                return ClassPathResourceFactory.this.securityManager.authenticate(user, password);
            }
            return "ok";
        }

        public boolean authorise(Request request, Request.Method method, Auth auth) {
            if (ClassPathResourceFactory.this.securityManager != null) {
                return ClassPathResourceFactory.this.securityManager.authorise(request, method, auth, (Resource)this);
            }
            return true;
        }

        public String getRealm() {
            if (ClassPathResourceFactory.this.securityManager != null) {
                return ClassPathResourceFactory.this.securityManager.getRealm(this.host);
            }
            return this.host;
        }

        public Date getModifiedDate() {
            return ClassPathResourceFactory.this.modifiedDate;
        }

        public String checkRedirect(Request request) {
            return null;
        }

        public Object authenticate(DigestResponse digestRequest) {
            if (ClassPathResourceFactory.this.securityManager != null) {
                return ClassPathResourceFactory.this.securityManager.authenticate(digestRequest);
            }
            return false;
        }

        public boolean isDigestAllowed() {
            return true;
        }

        public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException, ConflictException {
            return null;
        }
    }
}

