/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.common.Path;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WellKnownResourceFactory
implements ResourceFactory {
    public static final String URI_PREFIX = "/.well-known";
    private final ResourceFactory wrapped;
    private Map<String, WellKnownHandler> mapOfWellKnownHandlers = new HashMap<String, WellKnownHandler>();

    public WellKnownResourceFactory(ResourceFactory wrapped, List<WellKnownHandler> wellKnownHandlers) {
        this.wrapped = wrapped;
        for (WellKnownHandler h : wellKnownHandlers) {
            this.addHandler(h);
        }
    }

    public Resource getResource(String host, String sPath) throws NotAuthorizedException, BadRequestException {
        if (sPath.startsWith(URI_PREFIX)) {
            Resource hostRes;
            Path path = Path.path((String)sPath);
            WellKnownHandler wellKnown = this.mapOfWellKnownHandlers.get((path = path.getStripFirst()).getFirst());
            if (wellKnown != null && (hostRes = this.wrapped.getResource(host, "/")) != null) {
                return wellKnown.locateWellKnownResource(hostRes);
            }
        }
        return this.wrapped.getResource(host, sPath);
    }

    public final void addHandler(WellKnownHandler handler) {
        this.mapOfWellKnownHandlers.put(handler.getWellKnownName(), handler);
    }

    public static interface WellKnownHandler {
        public String getWellKnownName();

        public Resource locateWellKnownResource(Resource var1);
    }
}

