/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.event.DeleteEvent;
import io.milton.event.Event;
import io.milton.event.EventManager;
import io.milton.http.DeleteHelper;
import io.milton.http.HandlerHelper;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import io.milton.resource.DeletableCollectionResource;
import io.milton.resource.DeletableResource;
import io.milton.resource.Resource;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHelperImpl
implements DeleteHelper {
    private Logger log = LoggerFactory.getLogger(DeleteHelperImpl.class);
    private final HandlerHelper handlerHelper;

    public DeleteHelperImpl(HandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
    }

    @Override
    public boolean isLockedOut(Request req, Resource r) throws NotAuthorizedException, BadRequestException {
        if (r instanceof DeletableCollectionResource) {
            DeletableCollectionResource dcr = (DeletableCollectionResource)r;
            boolean locked = dcr.isLockedOutRecursive(req);
            if (locked && this.log.isInfoEnabled()) {
                this.log.info("isLocked, as reported by DeletableCollectionResource: " + dcr.getName());
            }
            return locked;
        }
        if (r instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)r;
            ArrayList list = new ArrayList();
            list.addAll(col.getChildren());
            for (Resource rChild : list) {
                if (rChild instanceof DeletableResource) {
                    DeletableResource rChildDel = (DeletableResource)rChild;
                    if (!this.isLockedOut(req, (Resource)rChildDel)) continue;
                    if (this.log.isInfoEnabled()) {
                        this.log.info("isLocked: " + rChild.getName() + " type:" + rChild.getClass());
                    }
                    return true;
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info("a child resource is not deletable: " + rChild.getName() + " type: " + rChild.getClass());
                }
                return true;
            }
            return false;
        }
        boolean locked = this.handlerHelper.isLockedOut(req, r);
        if (locked && this.log.isInfoEnabled()) {
            this.log.info("isLocked, as reported by handlerHelper on resource: " + r.getName());
        }
        return locked;
    }

    @Override
    public void delete(DeletableResource r, EventManager eventManager) throws NotAuthorizedException, ConflictException, BadRequestException {
        if (r instanceof DeletableCollectionResource) {
            r.delete();
            if (eventManager != null) {
                eventManager.fireEvent((Event)new DeleteEvent((Resource)r));
            }
        } else if (r instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)r;
            ArrayList list = new ArrayList();
            list.addAll(col.getChildren());
            for (Resource rChild : list) {
                if (rChild == null) {
                    this.log.warn("got a null item in list");
                    continue;
                }
                if (rChild instanceof DeletableResource) {
                    DeletableResource rChildDel = (DeletableResource)rChild;
                    this.delete(rChildDel, eventManager);
                    continue;
                }
                this.log.warn("Couldnt delete child resource: " + rChild.getName() + " of type; " + rChild.getClass().getName() + " because it does not implement: " + DeletableResource.class.getCanonicalName());
                throw new ConflictException(rChild);
            }
            r.delete();
            if (eventManager != null) {
                eventManager.fireEvent((Event)new DeleteEvent((Resource)r));
            }
        } else {
            r.delete();
            if (eventManager != null) {
                eventManager.fireEvent((Event)new DeleteEvent((Resource)r));
            }
        }
    }
}

